% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gatom.R
\name{makeMetabolicGraph}
\alias{makeMetabolicGraph}
\title{Creates metabolic graph based on specified data}
\usage{
makeMetabolicGraph(
  network,
  topology = c("atoms", "metabolites"),
  org.gatom.anno,
  gene.de,
  gene.de.meta = getGeneDEMeta(gene.de, org.gatom.anno),
  gene.keep.top = 12000,
  met.db,
  met.de,
  met.de.meta = getMetDEMeta(met.de, met.db),
  met.to.filter = fread(system.file("extdata", "mets2mask.lst", package = "gatom"))$ID,
  gene2reaction.extra = NULL,
  keepReactionsWithoutEnzymes = FALSE,
  largest.component = TRUE
)
}
\arguments{
\item{network}{Network object}

\item{topology}{Way to determine network vertices}

\item{org.gatom.anno}{Organism annotation object}

\item{gene.de}{Table with the differential gene expression, set to NULL if absent}

\item{gene.de.meta}{Annotation of `gene.de` table}

\item{gene.keep.top}{Only the `gene.keep.top` of the most expressed genes will be kept for the network}

\item{met.db}{Metabolite database}

\item{met.de}{Table with the differential expression for metabolites, set to NULL if absent}

\item{met.de.meta}{Annotation of `met.de` table}

\item{met.to.filter}{List of metabolites to filter from the network}

\item{gene2reaction.extra}{Additional gene to reaction mappings. Should be a data.table with `gene` and `reaction` columns}

\item{keepReactionsWithoutEnzymes}{If TRUE, keep reactions that have no annotated enzymes, thus expanding the network but
including some reactions which are not possible in the considered species.}

\item{largest.component}{If TRUE, only the largest connected component is returned}
}
\value{
igraph object created from input data
}
\description{
Creates metabolic graph based on specified data
}
\examples{
data("gene.de.rawEx")
data("met.de.rawEx")
data("met.kegg.dbEx")
data("networkEx")
data("org.Mm.eg.gatom.annoEx")
g <- makeMetabolicGraph(network = networkEx, topology = "atoms",
                   org.gatom.anno = org.Mm.eg.gatom.annoEx,
                   gene.de = gene.de.rawEx, met.db = met.kegg.dbEx,
                   met.de = met.de.rawEx)

}
