\name{gageComp}
\Rdversion{1.1}
\alias{gageComp}

\title{
Compare multiple GAGE analyses results
}
\description{
  This function is used to compare the results after running multiple
  rounds of GAGE analysis. It is frequently used after batch analysis
  using \code{gagePipe}, but may also be used after multiple runs of
  \code{gage} manually.
}
\usage{
gageComp(sampnames, dataname, gsname = c("kegg.gs", "go.gs"), use.cols =
c("stat.mean", "q.val"), q.cutoff = 0.1, do.plot = TRUE)
}

\arguments{
  \item{sampnames}{
    character vector, the names of the sample groups, on which the GAGE
    analysis has been done and to be compared. This same argument is
    used in \code{gagePipe} function. These \code{sampnames} have been used
    to label \code{gage} result objects.
  }
  \item{dataname}{
    character, the name of the data on which the GAGE analysis has been
    done. This same argument is used in \code{gagePipe} function. This name has be
    included as the prefix of the GAGE analysis output file names, and
    will be used in the comparison output file names.
  }
  \item{gsname}{
    character, the name(s) of the gene set collection(s) to be
    considered in the comparison. In other words, this argument
    specifies GAGE analysis results with what type(s) of gene sets
    are to be compared on. Default to be \code{c("kegg.gs", "go.gs")}.
  }
  \item{use.cols}{
    character, what columns in the \code{gage} analysis result objects will be used in the
    comparison. Default to be "stat.mean" (mean of gene set test
    statistics) and "q.val" (q-value using BH procedure). Check help
    information for \code{gage} function for more details on the result columns.
  }
    \item{q.cutoff}{
    numeric, q-value cutoff between 0 and 1 for signficant gene sets
    selection. Default to be 0.1. The same argument is used in
    \code{gagePipe} function.
  }
  \item{do.plot}{
    boolean, whether to plot the venn diagram for the comparison
    results. Default to be TRUE.
}
}
\details{
  \code{gageComp} works with the results of \code{gagePipe} run by
  default. Try to load the .RData file named after \code{dataname}
  first. It there is no such file, it assumes that the \code{gage}
  result objects have been loaded and exist in the global environment.
  
  For the GAGE analysis results with each gene set collection specified
  in \code{gsname}, \code{gagePipe} compares the signficant gene set
  lists between the sample groups specified in \code{sampnames}. For
  each gene set collection, three comparisons will be done, on the
  2-direction perturbed, up-regulated, and down-regulated gene sets.

  The comparison results are output as tab-delimited text files. Venn
  digrams are only plot for comparison between 2-3 parties. But the text
  file outputs are not limited by the number of parties under
  comparison. The venn diagram is generated by calling a revised
  function based on the VennDigram function from limma package.
}

\value{
  The function returns invisible 1 when successfully
  executed. 
}
\references{
  Luo, W., Friedman, M., Shedden K., Hankenson, K. and Woolf, P GAGE:
  Generally Applicable Gene Set Enrichment for Pathways Analysis. BMC
  Bioinformatics 2009, 10:161
}
\author{
  Weijun Luo <luo_weijun@yahoo.com>
}


\seealso{
  \code{\link{gagePipe}} pipeline for multiple GAGE analysis in a batch;
  \code{\link{gage}} the main function for GAGE analysis
}

\examples{
data(gse16873)
cn=colnames(gse16873)
hn=grep('HN',cn, ignore.case =TRUE)
dcis=grep('DCIS',cn, ignore.case =TRUE)
data(kegg.gs)

library(gageData)
data(gse16873.2)
cn2=colnames(gse16873.2)
hn2=grep('HN',cn2, ignore.case =TRUE)
dcis2=grep('DCIS',cn2, ignore.case =TRUE)

#multiple GAGE analysis in a batch with the combined data
gse16873=cbind(gse16873, gse16873.2)
dataname='gse16873' #output data prefix
sampnames=c('dcis.1', 'dcis.2')
refList=list(hn, hn2+12)
sampList=list(dcis, dcis2+12)
gagePipe(gse16873, gsname = "kegg.gs", dataname = "gse16873",
    sampnames = sampnames, ref.list = refList, samp.list = sampList,
    comp.list = "paired")

#follow up comparison between the analyses
load('gse16873.gage.RData')
#list gage result objects
objects(pat = "[.]p$")
gageComp(sampnames, dataname, gsname = "kegg.gs",
    do.plot = TRUE)
}

\keyword{htest}
\keyword{multivariate}
