% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concatentate_SEs.R
\name{promote_fields}
\alias{promote_fields}
\title{Promote a nested field to be represented as a metadata field of the \code{SummarizedExperiment}
as either the \code{rowData} or \code{colData}.}
\usage{
promote_fields(se, fields, MARGIN = c(1, 2))
}
\arguments{
\item{se}{\code{SummarizedExperiment} object.}

\item{fields}{Character vector of nested fields in a \code{BumpyMatrix} object to promote to
metadata fields of a \code{se}.}

\item{MARGIN}{Numeric of values \code{1} or \code{2} indicating whether to
promote fields to rows or columns respectively.}
}
\value{
A \code{SummarizedExperiment} object with new dimensions resulting from promoting given \code{fields}.
}
\description{
Promote a nested field to be represented as a metadata field of the \code{SummarizedExperiment}
as either the \code{rowData} or \code{colData}.
}
\details{
Revert this operation using \code{demote_fields}.
}
\examples{
mae <- get_synthetic_data("finalMAE_small")
se <- mae[[1]]
se <- promote_fields(se, "ReadoutValue", 2)

}
\seealso{
demote_fields
}
\keyword{SE_operators}
