% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{process_batch}
\alias{process_batch}
\title{Process and save a batch of results.}
\usage{
process_batch(
  batch,
  start_index,
  fun_name,
  unique_id,
  total_iterations,
  temp_dir,
  FUN,
  ...
)
}
\arguments{
\item{batch}{A subset of the vector or list \code{x} to be processed.}

\item{start_index}{Integer indicating the starting index of the batch in the original vector \code{x}.}

\item{fun_name}{Character string representing the name of the function \code{FUN} for use in file naming.}

\item{unique_id}{String with unique identifier for the current task and user to ensure file uniqueness.}

\item{total_iterations}{Integer indicating the total number of iterations in the original vector \code{x}.}

\item{temp_dir}{Character string specifying the directory where batch results are saved.}

\item{FUN}{A user-defined function to apply to each element of the batch.}

\item{...}{Optional arguments passed to \code{FUN}.}
}
\value{
This function does not return a value. It saves the processed batch results to disk as a \code{.qs} file.
}
\description{
Process and save a batch of results.
}
\details{
The function applies \code{FUN} to each element in \code{batch}, saves the results to a file named
according to the format \verb{<fun_name>_<unique_id>_<start_index>_of_<total_iterations>_batch.qs}, and clears
memory using \code{gc()} after saving.
}
\examples{
process_batch(list(1, 2, 3), 100, "my_function", "unique_task_id_user", 1000, tempdir(), function(x) x^2)

}
\keyword{package_utils}
