% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_validate.R
\name{validate_mae_with_schema}
\alias{validate_mae_with_schema}
\title{Validate MAE against a schema.}
\usage{
validate_mae_with_schema(
  mae,
  schema_package = Sys.getenv("SCHEMA_PACKAGE", "gDRutils"),
  schema_dir_path = Sys.getenv("SCHEMA_DIR_PATH", "schemas"),
  schema = c(se = "se.json", mae = "mae.json")
)
}
\arguments{
\item{mae}{MultiAssayExperiment object}

\item{schema_package}{string name of the package with JSON schema files}

\item{schema_dir_path}{path to the dir with JSON schema files}

\item{schema}{named charvec with filenames of schemas to validate against.}
}
\value{
Boolean of whether or not mae is valid
}
\description{
Validate MAE object against a schema.
Currently only SEs are validated
TODO: add mae.json schema and validate full MAE object
}
\examples{
mae <- get_synthetic_data("finalMAE_small") 
validate_mae_with_schema(mae)

}
\keyword{json_convert}
