% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize_MAE.R
\name{set_unique_drug_names}
\alias{set_unique_drug_names}
\title{Set Unique Drug Names}
\usage{
set_unique_drug_names(se)
}
\arguments{
\item{se}{A SummarizedExperiment object.}
}
\value{
A SummarizedExperiment object with unique \code{DrugName} fields in \code{rowData}.
}
\description{
This function sets the \code{DrugName}, \code{DrugName_2}, and \code{DrugName_3} fields in \code{rowData}
to be unique by appending the corresponding \code{Gnumber}, \code{Gnumber_2}, and \code{Gnumber_3} in parentheses for duplicates.
}
\examples{
se <- SummarizedExperiment::SummarizedExperiment(
  assays = list(counts = matrix(1:9, ncol = 3)),
  rowData = S4Vectors::DataFrame(DrugName = c("DrugA", "DrugA", "DrugB"),
  Gnumber = c("G1", "G2", "G5"),
  DrugName_2 = c("DrugC", "DrugC", "DrugD"),
  Gnumber_2 = c("G3", "G4", "G5")
))
se <- set_unique_drug_names(se)
}
\keyword{standardize_MAE}
