% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_curves.R
\name{predict_conc_from_efficacy}
\alias{predict_conc_from_efficacy}
\title{Predict a concentration for a given efficacy with fit parameters.}
\usage{
predict_conc_from_efficacy(efficacy, x_inf, x_0, ec50, h)
}
\arguments{
\item{efficacy}{Numeric vector representing efficacies to predict concentrations for.}

\item{x_inf}{Numeric vector representing the asymptotic value of the sigmoidal fit to the dose-response
data as concentration goes to infinity.}

\item{x_0}{Numeric vector representing the asymptotic metric value corresponding to a concentration of 0
for the primary drug.}

\item{ec50}{Numeric vector representing the drug concentration at half-maximal effect.}

\item{h}{Numeric vector representing the hill coefficient of the fitted curve, which reflects how steep}
}
\value{
Numeric vector representing predicted concentrations from given efficacies and fit parameters.
}
\description{
Predict a concentration for a given efficacy with fit parameters.
}
\details{
The inverse of this function is \code{predict_efficacy_from_conc}.
}
\examples{
predict_conc_from_efficacy(efficacy = c(1, 1.5), x_inf = 0.1, x_0 = 1, ec50 = 0.5, h = 2)

}
\seealso{
predict_efficacy_from_conc .calculate_x50
}
\keyword{fit_curves}
