% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combo.R
\name{define_matrix_grid_positions}
\alias{define_matrix_grid_positions}
\title{Define matrix grid positions}
\usage{
define_matrix_grid_positions(conc1, conc2)
}
\arguments{
\item{conc1}{drug_1 concentration}

\item{conc2}{drug_2 concentration}
}
\value{
list with axis grid positions
}
\description{
Define matrix grid positions
}
\details{
\code{drug_1} is diluted along the rows as the y-axis and
\code{drug_2} is diluted along the columns and will be the x-axis.
}
\examples{
cl_name <- "cellline_BC"
drug1_name <- "drug_001"
drug2_name <- "drug_026"

se <- get_synthetic_data("combo_matrix_small")[["combination"]]
dt_average <- convert_se_assay_to_dt(se, "Averaged")[normalization_type == "GR"]

ls_axes <- define_matrix_grid_positions(
   dt_average[["Concentration"]], dt_average[["Concentration_2"]])

}
\keyword{combination_data}
