% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prism_to_gdrDF.R
\name{convert_LEVEL6_prism_to_gDR_input}
\alias{convert_LEVEL6_prism_to_gDR_input}
\title{Load, convert and process the level 6 PRISM data into a gDR input}
\usage{
convert_LEVEL6_prism_to_gDR_input(
  prism_data_path,
  cell_line_data_path,
  treatment_data_path,
  meta_data_path,
  readout_min = 1.03
)
}
\arguments{
\item{prism_data_path}{path to PRISM LEVEL6 csv file with collapsed
log fold change data}

\item{cell_line_data_path}{path to cell line info data}

\item{treatment_data_path}{path to collapsed treatment info data}

\item{meta_data_path}{path to metadata file describing all cancer models/cell lines
which are referenced by a dataset contained within the DepMap portal}

\item{readout_min}{minimum ReadoutValue}
}
\value{
\code{data.table} object with input data for gDR pipeline
}
\description{
Load, convert and process the level 6 PRISM data into a gDR input
}
\examples{
 prism_data_path <- system.file("testdata/prism_collapsed_LOGFC.csv", package = "gDRimport")
 cell_line_data_path <- system.file("testdata/prism_cell_lines.csv", package = "gDRimport")
 treatment_data_path <- system.file("testdata/prism_treatment.csv", package = "gDRimport")
 prism_meta <- system.file("testdata/prism_model.csv", package = "gDRimport")
 convert_LEVEL6_prism_to_gDR_input(prism_data_path, cell_line_data_path, treatment_data_path, prism_meta)

}
\keyword{prism_conversion}
