% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_df.R
\name{map_df}
\alias{map_df}
\title{Map treated conditions to their respective references.}
\usage{
map_df(
  trt_md,
  ref_md,
  override_untrt_controls = NULL,
  ref_cols,
  ref_type = c("Day0", "untrt_Endpoint")
)
}
\arguments{
\item{trt_md}{data.table of treated metadata.}

\item{ref_md}{data.table of untreated metadata.}

\item{override_untrt_controls}{named list indicating what treatment metadata
fields should be used as a control. Defaults to \code{NULL}.}

\item{ref_cols}{character vector of the names of reference columns to
include. Likely obtained from \code{identify_keys()}.}

\item{ref_type}{string of the reference type to map to.
Should be one of \code{c("Day0", "untrt_Endpoint")}.}
}
\value{
named list mapping treated metadata to untreated metadata.
}
\description{
Map treated conditions to their respective Day0, untreated, or single-agent
references using condition metadata.
}
\details{
If \code{override_untrt_controls} is specified, the values in the
named list will supersede the values in \code{trt_md} during the matching
process. This is useful for mapping treatments to specific "standard"
untreated controls.
}
\examples{
# Standard Endpoint Mapping
trt_dt <- data.table::data.table(
  clid = c("C1", "C2"),
  Duration = 72,
  rn = c("T1", "T2")
)
ref_dt <- data.table::data.table(
  clid = c("C1", "C2"),
  Duration = 72,
  rn = c("R1", "R2")
)
map_df(trt_dt, ref_dt, ref_cols = "clid", ref_type = "untrt_Endpoint")

}
\seealso{
identify_keys
}
\keyword{map_df}
