% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_annotation.R
\name{get_drug_annotation}
\alias{get_drug_annotation}
\title{get_drug_annotation}
\usage{
get_drug_annotation(
  data,
  fname = "drugs.csv",
  fill = "unknown",
  annotation_package = if ("gDRinternal" \%in\% .packages(all.available = TRUE)) {
    
    "gDRinternal"
 } else {
     "gDRtestData"
 }
)
}
\arguments{
\item{data}{data.table with drug identifiers to be matched}

\item{fname}{string with file name containing the annotation}

\item{fill}{string indicating how unknown drugs should be filled in the DB}

\item{annotation_package}{string indicating name of the package containing drug annotation}
}
\value{
data.table with drug annotations
}
\description{
Get drug annotation data table
}
\examples{
data <- data.table::data.table(Gnumber = c("drug1", "drug2", "drug3"))
drug_annotation <- get_drug_annotation(data)
}
\keyword{annotation}
