% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinations-helpers.R
\name{calculate_excess}
\alias{calculate_excess}
\title{Calculate the difference between values in two data.tables}
\usage{
calculate_excess(
  metric,
  measured,
  series_identifiers,
  metric_col,
  measured_col
)
}
\arguments{
\item{metric}{data.table often representing
readouts derived by calculating some metric.
Examples of this could include hsa or bliss calculations
from single-agent data.}

\item{measured}{data.table often representing
measured data from an experiment.}

\item{series_identifiers}{character vector of identifiers in
\code{measured} or \code{metric}
which define a unique data point.}

\item{metric_col}{string of the column in \code{metric}
to use in excess calculation.}

\item{measured_col}{string of the column in \code{measured}
to use in excess calculation.}
}
\value{
data.table of \code{measured}, now with an additional column named
\code{excess} (positive values for synergy/benefit).
}
\description{
Calculate the difference between values, likely representing
the same metric, from two data.tables.
}
\examples{
metric <- data.table::data.table(
  Concentration = c(1, 2, 3, 1, 2, 3),
  Concentration_2 = c(1, 1, 1, 2, 2, 2),
  GRvalue = c(100, 200, 300, 400, 500, 600)
)
measured <- data.table::data.table(
  Concentration = c(3, 1, 2, 2, 1, 3),
  Concentration_2 = c(1, 1, 1, 2, 2, 2),
  testvalue = c(200, 0, 100, 400, 300, 500)
)
series_identifiers <- c("Concentration", "Concentration_2")
metric_col <- "GRvalue"
measured_col <- "testvalue"
calculate_excess(
  metric, 
  measured, 
  series_identifiers, 
  metric_col, 
  measured_col
)

}
\keyword{combinations}
