% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_annotation.R
\name{annotate_se_with_cell_line}
\alias{annotate_se_with_cell_line}
\title{annotate_se_with_cell_line}
\usage{
annotate_se_with_cell_line(se, cell_line_annotation, fill = "unknown")
}
\arguments{
\item{se}{SummarizedExperiment object containing dose-response data}

\item{cell_line_annotation}{data.table with cell line annotations}

\item{fill}{string indicating how unknown cell lines should be filled in the DB}
}
\value{
SummarizedExperiment object with annotated cell lines
}
\description{
Annotate SummarizedExperiment object with cell line annotations
}
\examples{
se <- SummarizedExperiment::SummarizedExperiment(
  rowData = data.table::data.table(clid = c("CL1", "CL2", "CL3"))
)
cell_line_annotation <- get_cell_line_annotation(data.table::as.data.table(SummarizedExperiment::rowData(se)))
annotated_se <- annotate_se_with_cell_line(se, cell_line_annotation)
}
\keyword{annotation}
