% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_df.R
\name{map_df}
\alias{map_df}
\title{Map treated conditions to their respective references.}
\usage{
map_df(
  trt_md,
  ref_md,
  override_untrt_controls = NULL,
  ref_cols,
  ref_type = c("Day0", "untrt_Endpoint")
)
}
\arguments{
\item{trt_md}{data.table of treated metadata.}

\item{ref_md}{data.table of untreated metadata.}

\item{override_untrt_controls}{named list indicating what treatment metadata
fields should be used as a control. Defaults to \code{NULL}.}

\item{ref_cols}{character vector of the names of reference columns to
include. Likely obtained from \code{identify_keys()}.}

\item{ref_type}{string of the reference type to map to.
Should be one of \code{c("Day0", "untrt_Endpoint", "ref_Endpoint")}.}
}
\value{
named list mapping treated metadata to untreated metadata.
}
\description{
Map treated conditions to their respective Day0, untreated, or single-agent
references using condition metadata.
}
\details{
If \code{override_untrt_controls} is specified,
TODO: FILL ME!
}
\examples{
n <- 64
md_df <- data.table::data.table(
  Gnumber = rep(c("vehicle", "untreated", paste0("G", seq(2))), each = 16), 
  DrugName = rep(c("vehicle", "untreated", paste0("GN", seq(2))), each = 16), 
  clid = paste0("C", rep_len(seq(4), n)),
  CellLineName = paste0("N", rep_len(seq(4), n)),
  replicates = rep_len(paste0("R", rep(seq(4), each = 4)), 64),
  drug_moa = "inhibitor",
  ReferenceDivisionTime = rep_len(c(120, 60), n),
  Tissue = "Lung",
  parental_identifier = "CL12345",
  Duration = 160
)
md_df <- unique(md_df)
ref <- md_df$Gnumber \%in\% c("vehicle", "untreated")
ref_df <- md_df[ref, ]
trt_df <- md_df[!ref, ]
Keys <- identify_keys(trt_df)
ref_type <- "untrt_Endpoint"
map_df(
  trt_df, 
  ref_df, 
  ref_cols = Keys[[ref_type]],
  ref_type = ref_type
)

}
\seealso{
identify_keys
}
\keyword{map_df}
