% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSingleCellExpression.R
\name{gs_get_singlecell_expression}
\alias{gs_get_singlecell_expression}
\alias{getSingleCellExpression}
\alias{getSingleCellExpressionByGate}
\alias{gs_get_singlecell_expression_by_gate}
\title{Return the cell events data that express in any of the single populations defined in \code{y}}
\usage{
gs_get_singlecell_expression(
  x,
  nodes,
  other.markers = NULL,
  swap = FALSE,
  threshold = TRUE,
  marginal = TRUE,
  mc.cores = getOption("mc.cores", 1L),
  inverse.transform = FALSE,
  ...
)

gs_get_singlecell_expression_by_gate(...)
}
\arguments{
\item{x}{A \code{GatingSet} or \code{GatingSetList} object .}

\item{nodes}{\code{character} vector specifying different cell populations}

\item{other.markers}{\code{character} vector specifying the extra markers/channels to be returned besides the ones derived from "nodes" and "map" argument.It is only valid when threshold is set to FALSE.}

\item{swap}{\code{logical} indicates whether channels and markers of flow data are swapped.}

\item{threshold}{\code{logical} indicates whether to threshold the flow data by setting intensity value to zero when it is below the gate threshold.}

\item{marginal}{\code{logical} indicates whether to the gate is treaded as 1d marginal gate. Default is TRUE, which means markers are determined either
by node name or by 'map' argument explained below. When FALSE, the markers are determined by the gate dimensions.
and node name and 'map' argument are ignored.}

\item{mc.cores}{passed to \code{mclapply}. Default is 1, which means the process runs in serial mode. When it is larger than 1, parallel mode is enabled.}

\item{inverse.transform}{logical flag indicating whether to inverse transform the data}

\item{...}{other arguments
        map a named list providing the mapping between node names (as specified in the gating hierarchy of the gating set) and channel
                        names (as specified in either the \code{desc} or \code{name}
                         columns of the parameters of the associated \code{flowFrame}s
                         in the \code{GatingSet}). see examples.

       ignore.case whether to ignore case when match the marker names. Default is FALSE.}
}
\value{
A \code{list} of \code{numerci matrices}
}
\description{
Returns a list of matrix containing the events that expressed in any one of the populations defined in \code{y}
}
\examples{
\dontrun{
  #G is a GatingSet
	nodes <- c("4+/TNFa+", "4+/IL2+")
	res <- gs_get_singlecell_expression(gs, nodes)
	res[[1]]
	
 # if it fails to match the given nodes to the markers, then try to provide the mapping between node and marker explicitly
	res <- gs_get_singlecell_expression(gs, nodes , map = list("4+/TNFa+" = "TNFa", "4+/IL2+" = "IL2"))
	
	# It can also operate on the 2d gates by setting marginal to FALSE
	# The markers are no longer deduced from node names or supplied by map
	# Instead, it retrieves the markers that are associated with the gates
	nodes <- c("4+/TNFa+IFNg+", "4+/IL2+IL3+")
	res <- gs_get_singlecell_expression(gs, nodes, marginal = FALSE)
	#or simply call convenient wrapper
	gs_get_singlecell_expression_by_gate(gs, nodes)
}
}
\seealso{
\code{\link{gh_pop_get_indices}}  \code{\link{gs_pop_get_count_fast}}
}
\author{
Mike Jiang \email{wjiang2@fhcrc.org}
}
