% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moveNode.R
\name{gh_pop_move}
\alias{gh_pop_move}
\alias{moveNode}
\title{move a node along with all of its descendant nodes to the given ancester}
\usage{
gh_pop_move(gh, node, to, recompute = TRUE)
}
\arguments{
\item{gh}{GatingHierarchy}

\item{node}{the node to be moved}

\item{to}{the new parent node under which the \code{node} will be moved to}

\item{recompute}{whether to recompute the gates after the node is moved. Default is TRUE.}
}
\description{
move a node along with all of its descendant nodes to the given ancester
}
\examples{
library(flowWorkspace)
dataDir <- system.file("extdata",package="flowWorkspaceData")
suppressMessages(gs <- load_gs(list.files(dataDir, pattern = "gs_manual",full = TRUE)))
gh <- gs[[1]]
old.parent <- gs_pop_get_parent(gh, "CD4")
new.parent <- "singlets"
gh_pop_move(gh, "CD4", new.parent)
gs_pop_get_parent(gh, "CD4")
}
