% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specMatCalc.R
\name{specMatCalc}
\alias{specMatCalc}
\title{Calculating the matrix used for spectral unmixing}
\usage{
specMatCalc(unmixCtrls, groupNames, autoFluoName)
}
\arguments{
\item{unmixCtrls}{A flowSet containing all the single stained and
unstained files necessary to create an spectral unmixing matrix. These can 
but do not have to, contain a negative control. Such a negative control will
not be used, and instead an universal negative control needs to be included
for each sample type present among the single-stained controls.}

\item{groupNames}{A character vector containing strings common to the groups
of non-autofluoresence unmixCtrls that could be present. If for example
all antibodies single stains are anti-mouse bead-based the dead cell marker
is stained PBMC, and the files congruently either have a prefix containing
"Bead" or "PBMC", then the vector should be c("Bead", "PBMC"). The system
is not case specific.}

\item{autoFluoName}{The sample name of the autofluorescence control.}
}
\value{
A data frame with each row representing a fluorochrome or
or autofluorescence and each column representing a detector.
}
\description{
This algoritm takes a flowSet containing single-stained controls and
negative controls, including an autofluorescence control and estimates the
unmixing for all fluorescent variables.
}
\examples{
# Load suitable unmixing controls. NB! If these originate from different
# sample types, such as beads and PBMC, there should be a negative control
# for each group and the names should reflect this, so that all PBMC samples
# would be called PBMC_unstained, PBMC_DCM, etc.
data(unmixCtrls)

# If the dataset contains cell controls, make sure that the cell population
# interest dominates FSC-A, as the data highest peak in this channel will be
# used.

# And run the function
specMat <- specMatCalc(unmixCtrls, groupNames = c("Beads_", "Dead_"),
autoFluoName = "PBMC_unstained.fcs")
}
