\name{plot.flowPeaks}
\alias{plot.flowPeaks}
\title{Plot the results generated by flowPeaks}
\description{This function takes the results generated from flowPeaks as
an input, and plot the data in 2D. These plots display the clustering
structure}
\usage{
\method{plot}{flowPeaks}(x,idx=c(1,2),drawlab=FALSE,
cols=c("red","green3","blue","cyan","magenta","yellow","gray"),drawvor=TRUE,
                         drawlocalpeaks=FALSE,drawkmeans=TRUE,drawboundary=TRUE,
                         classlab, negcol, negpch,\dots)
}
\arguments{
  \item{x}{Anobject of class flowPeaks, e.g., t
    the output from the functions \code{\link{flowPeaks}} or
    \code{\link{adjust.flowPeaks}}   }
  \item{idx}{The index of the columns will be used to plot the
    clustering. idx needs to be at least legnth 2, and have no duplicate
    elements,
    and the values can
    only take from 1 to d, where d is the number of columns for the
    input matrix x that is used as an input of the function flowPeaks}
  \item{drawlab}{The option to decide whether we should draw the cluster
    labels}
  \item{cols}{The color specification for plotting the points in each
    cluster. Please note, "white" and "black" are not allowed, which are
    reserved for other purpse}
  \item{drawvor}{Deciding whether the voronoi diagram should be drawn,
    only good for 2D data}
  \item{drawlocalpeaks}{Decding whether the local peaks with a triangle symbol should
  be drawn}
\item{drawkmeans}{Deciding whether the kmeans center with a filled
  circle should be drawn}
\item{drawboundary}{Deciding whether the boudary between clusters should
  be drawn, only good for 2D data}
\item{classlab}{Use this to replace the default class labels from
  x$peak.cluster, for example, the classlab may come from
  \code{\link{assign.flowPeaks}}}
\item{negcol}{Deciding the color of the negative, which are outliers}
 \item{negpch}{Deciing the symbols for the outliers} 
 \item{\dots}{Optional additional arguments.  At present no additional
   arguments are used.}
}
\author{
  Yongchao Ge \email{yongchao.ge@gmail.com}
}
\keyword{plot,multivariate,smooth}
\seealso{\code{\link{flowPeaks}}}   
    
    
    
