% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_flowgraph_accessors.R
\name{fg_get_feature_means}
\alias{fg_get_feature_means}
\title{Retrieves feature summaries.}
\usage{
fg_get_feature_means(
  fg,
  type = c("node", "edge"),
  feature = "count",
  class = NULL,
  label = NULL,
  id = NULL,
  summary_fun = colMeans
)
}
\arguments{
\item{fg}{flowGraph object.}

\item{type}{A string indicating feature type the summary was created for
'node' or 'edge'.}

\item{feature}{A string indicating feature name the summary was created for;}

\item{class}{A string corresponding to a column name of the \code{meta} slot of
\code{fg} whose values represent the class label of each sample
on which the summary was created to compare or analyze;}

\item{label}{A string indicating a class label.}

\item{id}{A string vector containing the sample id's corresponding to the
\code{id} column of the \code{meta} slot of \code{fg}.}

\item{summary_fun}{A function that takes in a matrix and outputs a
vector the same length as the number of columns this matrix has.}
}
\value{
A list containing two numeric vectors calculated using the
 \code{summary_fun} function on the subset of samples specified by
 sample id's \code{id} OR class label
 \code{label} for class \code{class} from a feature matrix
 specified by \code{type} and \code{feat}.
}
\description{
Retrieves a feature summary (e.g. \code{colMeans}) for samples
 specified by sample id's \code{id} OR class label
 \code{label} for class \code{class} given a feature specified
 by \code{type} and \code{feat}.
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 no_cores=no_cores)
 fg <- fg_summary(fg, no_cores=no_cores, class="class", label1="control",
                  overwrite=FALSE, test_name="t", diminish=FALSE)
 show(fg)
 feat_mean <- fg_get_feature_means(fg, type="node", feature="count",
                                   class="class", label="control")

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_get_summary_desc}}
 \code{\link[flowGraph]{fg_add_summary}}
 \code{\link[flowGraph]{fg_rm_summary}}
 \code{\link[flowGraph]{fg_get_summary}}
}
