% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_flowgraph_features.R
\name{fg_feat_node_specenr}
\alias{fg_feat_node_specenr}
\title{Generates the SpecEnr node feature.}
\usage{
fg_feat_node_specenr(fg, no_cores = 1, feature = "prop", overwrite = FALSE)
}
\arguments{
\item{fg}{flowGraph object}

\item{no_cores}{An integer indicating how many cores to parallelize on.}

\item{feature}{A string indicating feature name; this is the feature
SpecEnr will be calculated on.}

\item{overwrite}{A logical variable indicating whether to
overwrite the existing SpecEnr node feature if it exists.}
}
\value{
flowGraph object containing the SpecEnr node feature.
}
\description{
Generates the SpecEnr node feature and returns it
 inside the returned flowGraph object.
}
\details{
Given a flowGraph object, \code{fg_feat_node_specenr}
 returns the same
 flowGraph object with an additional \code{SpecEnr} and \code{expect_prop}
 \code{node} feature and its meta data.
 The expected proportions feature is made using the \code{prop} \code{node}
 and \code{edge} features; therefore, the returned flowGraph will also
 contain these two features. For details on how these feature is calculated.
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 prop=FALSE, specenr=FALSE,
                 no_cores=no_cores)

 # SpecEnr is by default calculated based on proportions
 fg <- fg_feat_node_specenr(fg, no_cores=no_cores)

 # SpecEnr can be calculated for other feature values too
 fg <- fg_feat_node_specenr(fg, feature="count")

 show(fg)

}
\references{
\insertRef{yue2019identifying}{flowGraph}
}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_feat_node_prop}}
 \code{\link[flowGraph]{fg_add_feature}}
 \code{\link[flowGraph]{fg_get_feature}}
 \code{\link[flowGraph]{fg_rm_feature}}
 \code{\link[flowGraph]{fg_get_feature_desc}}
}
