% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{transformMap-class}
\alias{transformMap-class}
\alias{transformMap}
\alias{show,transformMap-method}
\title{A class for mapping transforms between parameters}
\description{
This class provides a mapping between parameters and transformed parameters
via a function.
}
\section{Slots}{

\describe{
\item{\code{output}}{Name of the transformed parameter.}

\item{\code{input}}{Name of the parameter to transform.}

\item{\code{f}}{Function used to accomplish the transform.}
}}

\section{Objects from the Class}{


Objects of this type are not usually created by the user, except perhaps in
special circumstances. They are generally automatically created by the
inline \code{\link[flowCore:transform-class]{transform}} process during the
creation of a \code{\link{transformFilter}}, or by a call to the
\code{\link{transformList}} constructor.
}

\section{Methods}{

\describe{
  \item{show}{\code{signature(object = "transformList")}: Print details
    about the object. }
}
}

\examples{

new("transformMap", input="FSC-H", output="FSC-H", f=log)


}
\seealso{
\code{\link{transform}}, \code{\link{transformList}}
}
\author{
B. Ellis, F. Hahne
}
\keyword{classes}
