% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{subsetFilter-class}
\alias{subsetFilter-class}
\alias{subsetFilter}
\alias{show,subsetFilter-method}
\alias{summary,subsetFilter-method}
\title{Class subsetFilter}
\description{
This class represents the action of applying a filter on the subset of
data resulting from another filter. This is itself a filter that can be 
incorporated in to further set operations. This is similar to an
intersectFilter, with behavior only differing if the component filters
are data-driven.
}
\details{
\code{subsetFilter}s are constructed using the equivalent binary set operators 
\code{"\%&\%"} or \code{"\%subset\%"}. The operator is not symmetric, as the
filter on the right-hand side will take the subset of the filter on the
left-hand side as input. Left-hand side operands can be a filter or list of
filters, while the right-hand side operand must be a single
filter.
}
\section{Slots}{

\describe{
\item{\code{filters}}{Object of class \code{"list"}, containing the component filters.}

\item{\code{filterId}}{Object of class \code{"character"}
referencing the filter applied.}
}}

\section{Extends}{


Class \code{"\linkS4class{filter}"}, directly.
}

\seealso{
\code{\link[flowCore:filter-methods]{filter}}, \code{\linkS4class{setOperationFilter}}

Other setOperationFilter classes: 
\code{\link{complementFilter-class}},
\code{\link{intersectFilter-class}},
\code{\link{setOperationFilter-class}},
\code{\link{unionFilter-class}}
}
\author{
B. Ellis
}
\concept{setOperationFilter classes}
\keyword{classes}
