% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumRanks.R
\name{sumRanks}
\alias{sumRanks}
\title{Summarize the weighted rank changes caused by case-deletion}
\usage{
sumRanks(origRank, drop1Rank, topN = NULL, method = "adaptive", ...)
}
\arguments{
\item{origRank}{vectors, reference rankings. For influential observation
detection, origRank denotes the original ranking obtained using the whole
data.}

\item{drop1Rank}{matrix or data.frame, Each column is a feature list with
a case removed.}

\item{topN}{the top n features in origRank will be used for rank comparison.
If null, include all features.}

\item{method}{method to summarize rank changes. It should be one of the
'adaptive', 'weightedSpearman', and 'unweighted'. Both 'adaptive' and
'weightedSpearman' are weighted rank comparison method, but former employs
the weight that are adaptive to the distribution of rank changes.
'unweighted' denotes a direct comparison of ranks without considering
weights.}

\item{...}{other arguments}
}
\value{
\item{kappa}{The weight function's shape is controlled by kappa,
which ranges from 0 to 1. Weighted rank changes are calculated using kappa,
with higher values indicating more weight on top features.}

\item{score}{The influence of each observation on feature rankings,
with larger values indicating more influence.}

\item{origRank}{The original ranking. origRank is exactly the input.
Here it is re-output for visualization purposes.}

\item{drop1Rank}{The leave-one-out rankings. }

\item{origRankWeighted}{The weighted original ranking.
origRankWeighted will be returned when method = 'adaptive'. }

\item{drop1RankWeighted}{The weighted leave-one-out rankings.
drop1RankWeighted will be returned when method = 'adaptive'. }
}
\description{
This function measures the overall rank changes due to case deletion.
A large rank changes indicates more influence of the deleted case on feature
rankings. \code{sumRanks()} provides three methods to compute the overall
rank changes: unweighted, weighted Spearman, and adaptive weights.
}
\examples{

data(miller05)
X <- miller05$X
y <- miller05$y
obj <- getdrop1ranks(X, y,
                     fun = 't.test',
                     decreasing = FALSE,
                     topN = 100)

rks <- sumRanks(origRank = obj$origRank,
                drop1Rank = obj$drop1Rank,
                topN = 100,
                method = 'adaptive')

plotIPs(rks, topn = 5, ylim = NULL)

}
