% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAdaptiveWeights.R
\name{plotAdaptiveWeights}
\alias{plotAdaptiveWeights}
\title{Visualize the weight function for adaptive weights}
\usage{
plotAdaptiveWeights(kappa, n, type = c("line", "points"), ylim = NULL)
}
\arguments{
\item{kappa}{a shape parameter of the weight function.}

\item{n}{the length list.}

\item{type}{draw line or points. Both line and points will be plotted if
type = c('line', 'points').}

\item{ylim}{y coordinates ranges.}
}
\value{
plot based on basic graph
}
\description{
Plot the weight function for the adaptive weights with given kappa
and the list length (n).
}
\examples{

par(mfrow = c(1, 2), mar = c(4, 4, 2, 2))
plotAdaptiveWeights(kappa = 0.01, n = 100, type = 'line', ylim = c(0, 0.025))
plotAdaptiveWeights(kappa = 0.02, n = 100, type = 'line', ylim = c(0, 0.025))

}
