/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.javautils;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.gkano.bioinfo.tree.Clade;
import com.gkano.bioinfo.tree.HierarchicalCluster;
import com.gkano.bioinfo.var.GeneralTools;
import com.gkano.bioinfo.var.Logger;
import com.gkano.bioinfo.vcf.SNPEncoder;
import com.gkano.bioinfo.vcf.VCFManager;
import com.gkano.bioinfo.vcf.VariantEmbeddingLoader;
import com.gkano.bioinfo.vcf.VariantKeyExtractor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Parameters(commandDescription="VCF2TREE")
public class UtilVCF2TREE {
    @Parameter(names={"--help"}, help=true)
    private boolean help;
    @Parameter(names={"-v", "--verbose"})
    private boolean verbose = false;
    @Parameter(description="<positional input files>")
    private List<String> positionalInputFiles = new ArrayList<String>();
    @Parameter(names={"-i", "--input"}, description="VCF input file(s)", variableArity=true)
    private List<String> namedInputFiles = new ArrayList<String>();
    @Parameter(names={"-o", "--output"}, description="Tree output file")
    private String outputFile;
    @Parameter(names={"--numberOfThreads", "-t"})
    private int numOfThreads = 1;
    @Parameter(names={"--bootstrap", "-b"}, description="Number of bootstrap replicates")
    private int numBootstraps = 0;
    @Parameter(names={"-e", "--embeddings"}, description="Variant embeddings file for embedding-based distance calculation")
    private String embeddingsFile;
    @Parameter(names={"--embeddings-format"}, description="Embeddings file format: TSV or HUGGINGFACE (auto-detected if not specified)")
    private String embeddingsFormat;
    @Parameter(names={"--variant-key"}, description="Variant key format for embedding lookup: CHROM_POS, CHROM_POS_REF_ALT, or VCF_ID")
    private String variantKeyFormat = "CHROM_POS_REF_ALT";

    public static String getUtilName() {
        return "VCF2TREE";
    }

    public void go() {
        try (PrintStream ops = GeneralTools.getPrintStreamOrExit(this.outputFile, this);){
            VCFManager vcfm = new VCFManager(Stream.concat(this.positionalInputFiles.stream(), this.namedInputFiles.stream()).collect(Collectors.toList()), this.numOfThreads, SNPEncoder.StringToStringParser, this.verbose);
            vcfm.setNumBootstraps(this.numBootstraps);
            if (this.embeddingsFile != null && !this.embeddingsFile.isEmpty()) {
                Map<String, double[]> embeddings;
                Logger.info(this, "Loading embeddings from: " + this.embeddingsFile);
                if (this.embeddingsFormat != null && !this.embeddingsFormat.isEmpty()) {
                    VariantEmbeddingLoader.EmbeddingFormat format = VariantEmbeddingLoader.EmbeddingFormat.valueOf(this.embeddingsFormat.toUpperCase());
                    embeddings = VariantEmbeddingLoader.loadEmbeddings(this.embeddingsFile, format);
                } else {
                    embeddings = VariantEmbeddingLoader.loadEmbeddings(this.embeddingsFile);
                }
                VariantKeyExtractor.KeyFormat keyFormat = VariantKeyExtractor.parseFormat(this.variantKeyFormat);
                vcfm.setEmbeddings(embeddings, keyFormat);
            }
            vcfm.init();
            new Thread(vcfm).start();
            vcfm.awaitFinalization();
            List<String> sampleNames = vcfm.getSampleNames();
            if (sampleNames.size() < 2) {
                Logger.error(this, "At least two samples are required to build a tree.");
                return;
            }
            if (this.numBootstraps > 0) {
                List<double[][]> allDistances = vcfm.reduceDotProdToDistancesBootstraps();
                HierarchicalCluster hc = new HierarchicalCluster(this.verbose);
                Logger.info(this, allDistances.size() + " distance matrices computed (1 original + " + (allDistances.size() - 1) + " bootstraps).");
                if (vcfm.isEmbeddingMode()) {
                    int used = vcfm.getNumVariants() - vcfm.getSkippedVariants();
                    Logger.info(this, "Used " + used + " variants with embeddings (skipped " + vcfm.getSkippedVariants() + ")");
                }
                Object[] originalTreeAndRoot = hc.hclusteringTree((String[])sampleNames.toArray(String[]::new), allDistances.get(0), null);
                String originalTree = (String)originalTreeAndRoot[0];
                Clade originalRoot = (Clade)originalTreeAndRoot[1];
                ArrayList<Clade> bootstrapTrees = new ArrayList<Clade>();
                for (int b = 1; b < allDistances.size(); ++b) {
                    Object[] bootTreeAndRoot = hc.hclusteringTree((String[])sampleNames.toArray(String[]::new), allDistances.get(b), null);
                    String bootTree = (String)bootTreeAndRoot[0];
                    Clade bootRoot = (Clade)bootTreeAndRoot[1];
                    bootstrapTrees.add(bootRoot);
                }
                Clade.annotateTreeWithBootstrap(originalRoot, bootstrapTrees, sampleNames.size(), this.numBootstraps);
                ops.println(Clade.cladeToString(originalRoot));
            } else {
                double[][] distances = vcfm.reduceDotProdToDistances();
                if (vcfm.isEmbeddingMode()) {
                    int used = vcfm.getNumVariants() - vcfm.getSkippedVariants();
                    Logger.info(this, "Used " + used + " variants with embeddings (skipped " + vcfm.getSkippedVariants() + ")");
                }
                HierarchicalCluster hc = new HierarchicalCluster(this.verbose);
                String treeString = (String)hc.hclusteringTree((String[])sampleNames.toArray(String[]::new), distances, null)[0];
                ops.println(treeString);
            }
            ops.close();
        }
        catch (Exception e) {
            Logger.error(this, e.getMessage());
        }
    }
}

