/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.javautils;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.gkano.bioinfo.tree.HierarchicalCluster;
import com.gkano.bioinfo.var.GeneralTools;
import com.gkano.bioinfo.var.Logger;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.TreeMap;
import java.util.TreeSet;

@Parameters(commandDescription="DIST2Clusters")
public class UtilDIST2Clusters {
    @Parameter(names={"--help"}, help=true)
    private boolean help;
    @Parameter(names={"-v", "--verbose"})
    private boolean verbose = false;
    @Parameter(description="<positional input file>")
    private String positionalInputFile;
    @Parameter(names={"-i", "--input"}, description="Input file (overrides positional)")
    private String namedInputFile;
    @Parameter(names={"-o", "--output"}, description="Tree output file")
    private String outputFile;
    @Parameter(names={"--cutHeight", "-c"})
    private Double cutHeight = null;
    @Parameter(names={"--minClusterSize", "-m"})
    private Integer minClusterSize = 1;
    @Parameter(names={"--extra", "-e"})
    private boolean extra = false;

    public static String getUtilName() {
        return "DIST2Clusters";
    }

    public void go() {
        try (PrintStream ops = GeneralTools.getPrintStreamOrExit(this.outputFile, this);){
            Object[] data;
            String inputFileName;
            String string = inputFileName = this.namedInputFile != null ? this.namedInputFile : this.positionalInputFile;
            if (inputFileName == null) {
                Logger.error(this, "No input file provided.");
                return;
            }
            if ("-".equals(inputFileName)) {
                data = GeneralTools.readDistancesSamples(System.in);
            } else {
                try (FileInputStream fis = new FileInputStream(inputFileName);){
                    data = GeneralTools.readDistancesSamples(fis);
                }
            }
            HierarchicalCluster hc = new HierarchicalCluster(true);
            TreeMap<Integer, TreeSet<String>> clusters = hc.hclusteringClusters((String[])data[1], (double[][])data[0], this.minClusterSize, this.cutHeight, this.extra, ops);
            ops.flush();
            ops.close();
        }
        catch (IOException e) {
            Logger.error(this, e.getMessage());
        }
    }
}

