/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.fasta;

import com.gkano.bioinfo.fasta.FastaManager;
import com.gkano.bioinfo.fasta.Sequence;
import com.gkano.bioinfo.fasta.SequenceD2;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

public class SequenceProcessor
implements Runnable {
    private static AtomicInteger sequenceCount = new AtomicInteger(0);
    private static AtomicInteger taskCount = new AtomicInteger(0);
    private final int id = taskCount.getAndIncrement();
    private FastaManager frm = null;
    private int k;
    private boolean normalize;
    private CountDownLatch startSignal = null;
    private CountDownLatch doneSignal = null;
    private boolean verbose = false;
    private ConcurrentHashMap<Integer, SequenceD2> seqVectors;

    public static void resetCounters() {
        sequenceCount = new AtomicInteger(0);
        taskCount = new AtomicInteger(0);
    }

    public SequenceProcessor(ConcurrentHashMap<Integer, SequenceD2> seqVectors, FastaManager frm, int k, boolean normalize, CountDownLatch startSignal, CountDownLatch doneSignal, boolean verbose) {
        this.seqVectors = seqVectors;
        this.frm = frm;
        this.k = k;
        this.normalize = normalize;
        this.startSignal = startSignal;
        this.doneSignal = doneSignal;
        this.verbose = verbose;
    }

    public static AtomicInteger getSequenceCount() {
        return sequenceCount;
    }

    public void setStartSignal(CountDownLatch startSignal) {
        this.startSignal = startSignal;
    }

    public void setDoneSignal(CountDownLatch doneSignal) {
        this.doneSignal = doneSignal;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void run() {
        try {
            this.startSignal.await();
            boolean done = false;
            while (!done) {
                Sequence sequence = this.frm.getNextSequence();
                SequenceD2 sequenceD2 = null;
                if (sequence != null) {
                    sequenceD2 = new SequenceD2(sequence);
                    sequenceD2.getName();
                    sequenceD2.getShortName();
                }
                if (sequenceD2 == null) {
                    if (this.frm.hasMore()) continue;
                    done = true;
                    break;
                }
                sequenceCount.incrementAndGet();
                int i = 0;
                while (i + this.k <= sequenceD2.getLength()) {
                    int oldAs = sequenceD2.as;
                    int oldTs = sequenceD2.ts;
                    int oldCs = sequenceD2.cs;
                    int oldGs = sequenceD2.gs;
                    long kmerCode = SequenceProcessor.encodeToLong(sequenceD2, i, i + this.k, false, true);
                    if (kmerCode >= 0L) {
                        sequenceD2.insertKmerCount(kmerCode, 1);
                        sequenceD2.insertKmerProb(kmerCode, (short)(sequenceD2.as - oldAs), (short)(sequenceD2.ts - oldTs), (short)(sequenceD2.cs - oldCs), (short)(sequenceD2.gs - oldGs));
                    }
                    oldAs = sequenceD2.as;
                    oldTs = sequenceD2.ts;
                    oldCs = sequenceD2.cs;
                    oldGs = sequenceD2.gs;
                    kmerCode = SequenceProcessor.encodeToLong(sequenceD2, i, i + this.k, true, true);
                    if (kmerCode >= 0L) {
                        sequenceD2.insertKmerCount(kmerCode, 1);
                        sequenceD2.insertKmerProb(kmerCode, (short)(sequenceD2.as - oldAs), (short)(sequenceD2.ts - oldTs), (short)(sequenceD2.cs - oldCs), (short)(sequenceD2.gs - oldGs));
                    }
                    ++i;
                }
                double sumprob = sequenceD2.calculateProbs(this.k);
                if (this.normalize) {
                    sequenceD2.normalizeProbs(sequenceD2.getNorm());
                }
                SequenceD2 seqVector = sequenceD2;
                this.seqVectors.put(seqVector.getSequenceId(), seqVector);
                if (this.verbose) {
                    System.err.println(sequenceCount.get() + "\t" + seqVector.getShortName());
                }
                sequenceD2.clearHeadSeq();
            }
            this.doneSignal.countDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static long encodeToLong(Sequence sequence, int start, int end, boolean reverse) {
        if (!reverse) {
            long num = 0L;
            for (int i = start; i < end; ++i) {
                num *= 4L;
                switch (sequence.charAt(i)) {
                    case 'A': 
                    case 'a': {
                        num += 0L;
                        break;
                    }
                    case 'T': 
                    case 't': {
                        ++num;
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        num += 2L;
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        num += 3L;
                        break;
                    }
                    default: {
                        num = -1L;
                    }
                }
                if (num == -1L) break;
            }
            return num;
        }
        long num = 0L;
        for (int i = end - 1; i >= start; --i) {
            num *= 4L;
            switch (sequence.charAt(i)) {
                case 'A': 
                case 'a': {
                    ++num;
                    break;
                }
                case 'T': 
                case 't': {
                    num += 0L;
                    break;
                }
                case 'C': 
                case 'c': {
                    num += 3L;
                    break;
                }
                case 'G': 
                case 'g': {
                    num += 2L;
                    break;
                }
                default: {
                    num = -1L;
                }
            }
            if (num == -1L) break;
        }
        return num;
    }

    public static long encodeToLong(SequenceD2 sequence, int start, int end, boolean reverse, boolean countNucl) {
        if (!reverse) {
            long num = 0L;
            int a = 0;
            int t = 0;
            int c = 0;
            int g = 0;
            for (int i = start; i < end; ++i) {
                num *= 4L;
                switch (sequence.charAt(i)) {
                    case 'A': 
                    case 'a': {
                        num += 0L;
                        if (!countNucl) break;
                        a = (short)(a + 1);
                        break;
                    }
                    case 'T': 
                    case 't': {
                        ++num;
                        if (!countNucl) break;
                        t = (short)(t + 1);
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        num += 2L;
                        if (!countNucl) break;
                        c = (short)(c + 1);
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        num += 3L;
                        if (!countNucl) break;
                        g = (short)(g + 1);
                        break;
                    }
                    default: {
                        num = -1L;
                    }
                }
                if (num == -1L) break;
            }
            if (countNucl && num != -1L) {
                sequence.as += a;
                sequence.ts += t;
                sequence.cs += c;
                sequence.gs += g;
            }
            return num;
        }
        long num = 0L;
        int a = 0;
        int t = 0;
        int c = 0;
        int g = 0;
        for (int i = end - 1; i >= start; --i) {
            num *= 4L;
            switch (sequence.charAt(i)) {
                case 'A': 
                case 'a': {
                    ++num;
                    if (!countNucl) break;
                    t = (short)(t + 1);
                    break;
                }
                case 'T': 
                case 't': {
                    num += 0L;
                    if (!countNucl) break;
                    a = (short)(a + 1);
                    break;
                }
                case 'C': 
                case 'c': {
                    num += 3L;
                    if (!countNucl) break;
                    g = (short)(g + 1);
                    break;
                }
                case 'G': 
                case 'g': {
                    num += 2L;
                    if (!countNucl) break;
                    c = (short)(c + 1);
                    break;
                }
                default: {
                    num = -1L;
                }
            }
            if (num == -1L) break;
        }
        if (countNucl && num != -1L) {
            sequence.as += a;
            sequence.ts += t;
            sequence.cs += c;
            sequence.gs += g;
        }
        return num;
    }

    public static String decodeFromLong(long encoded, int length) {
        StringBuilder sbf = new StringBuilder();
        StringBuilder sbr = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int mod = (int)(encoded % 4L);
            switch (mod) {
                case 0: {
                    sbf.append('A');
                    sbr.append('T');
                    encoded -= 0L;
                    break;
                }
                case 1: {
                    sbf.append('T');
                    sbr.append('A');
                    --encoded;
                    break;
                }
                case 2: {
                    sbf.append('C');
                    sbr.append('G');
                    encoded -= 2L;
                    break;
                }
                case 3: {
                    sbf.append('G');
                    sbr.append('C');
                    encoded -= 3L;
                    break;
                }
            }
            encoded /= 4L;
        }
        String f = sbf.reverse().toString();
        String r = sbr.toString();
        return f + "/" + r;
    }

    public static long encodeToLong(String kmerS, int k) {
        long num = 0L;
        for (int i = 0; i < k; ++i) {
            num *= 4L;
            switch (kmerS.charAt(i)) {
                case 'A': 
                case 'a': {
                    num += 0L;
                    break;
                }
                case 'T': 
                case 't': {
                    ++num;
                    break;
                }
                case 'C': 
                case 'c': {
                    num += 2L;
                    break;
                }
                case 'G': 
                case 'g': {
                    num += 3L;
                    break;
                }
                default: {
                    num = -1L;
                }
            }
            if (num == -1L) break;
        }
        return num;
    }
}

