% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/propOverlaps.R
\name{propOverlap}
\alias{propOverlap}
\alias{propOverlap,GRanges,GRanges-method}
\title{Find the proportions of an overlapping range}
\usage{
propOverlap(x, y, ...)

\S4method{propOverlap}{GRanges,GRanges}(x, y, ignore.strand = FALSE, ...)
}
\arguments{
\item{x, y}{A GenomicRanges object}

\item{...}{Not used}

\item{ignore.strand}{If set to TRUE, then the strand of x and y is set to
"*" prior to any computation.}
}
\value{
Numeric vector the same length as x
}
\description{
Find the proportion of a query reange which overlaps the subject
}
\details{
This behaves similarly to \link[IRanges]{overlapsAny} except the proportion
of the query range which overlaps one or more subject ranges is returned
instead of a logical vector
}
\examples{
x <- GRanges("chr1:1-10")
y <- GRanges("chr1:1-5")
propOverlap(x, y)
propOverlap(y, x)

}
