% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/grlToSE.R
\name{grlToSE}
\alias{grlToSE}
\alias{grlToSE,GRangesList-method}
\title{Set columns from a GRangesList as Assays in a SummarizedExperiment}
\usage{
grlToSE(x, ...)

\S4method{grlToSE}{GRangesList}(
  x,
  assayCols = c(),
  metaCols = c(),
  keyvals = c(),
  by = c("min", "max"),
  ...,
  ignore.strand = FALSE
)
}
\arguments{
\item{x}{A GrangesList}

\item{...}{Passed to \link[GenomicRanges]{reduce}}

\item{assayCols}{Columns to move to separate assays}

\item{metaCols}{Columns to move to mcols within the rowRanges element}

\item{keyvals}{The value to use when choosing representative values}

\item{by}{How to choose by keyvals}

\item{ignore.strand}{logical(1). Whether the strand of the input ranges
should be ignored or not.}
}
\value{
A RangedSummarizedExperiment
}
\description{
Move one or more columns from a GRangesList elements into
assays in a RangesSummarizedEperiment
}
\details{
Given a GRangesList which would commonly represent multiple samples, reduce
any overlapping ranges into a consensus range, setting any metadata columns
to be retained as separate assays. These columns may contain values such as
coverage, p-values etc.

Additional columns can also be placed as rowData columns where the original
values are better suited to information about the consensus range rather
than the sample (or GRangesList element).

Only one value for each range will be retained, and these are chosen using
the value provided as the keyvals, taking either the min or max value in this
column as the representative range.
}
\examples{
a <- GRanges("chr1:1-10")
a$feature <- "Gene"
a$p <- 0.1
b <- GRanges(c("chr1:6-15", "chr1:15"))
b$feature <- c("Gene", "Promoter")
b$p <- c(0.5, 0.01)
grl <- GRangesList(a = a, b = b)
grl
se <- grlToSE(
  grl, assayCols = "p", metaCols = "feature", keyvals = "p", by = "min"
)
assay(se, "p")
rowRanges(se)

}
