% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTopElements.R
\name{getTopElements}
\alias{getTopElements}
\title{create \code{geom_text} object with top genes/sample/pathways}
\usage{
getTopElements(
  top,
  type = c("gene", "sample", "geneSets"),
  var = character(),
  dataPlotGenes = data.frame(),
  dataPlotSamples = data.frame(),
  esetUsed,
  geneSets = list(),
  geneSetsVar = character(),
  geneSetsMaxNChar = numeric()
)
}
\arguments{
\item{top}{numeric, number of top elements}

\item{type}{type of elements to plot, either 'gene', 'sample', or 'geneSets'}

\item{var}{variable used to annotate the elements, only used for 'gene' and 'sample'}

\item{dataPlotGenes}{data.frame with two columns 'X' and 'Y' with coordinates for the genes}

\item{dataPlotSamples}{data.frame with two columns 'X' and 'Y' with coordinates for the samples}

\item{esetUsed}{expressionSet (or SummarizedExperiment) object with data}

\item{geneSets}{list of gene sets, e.g. gene pathways, output from the 'getGeneSets' function in MLP
the genes IDs must correspond to the sampleNames in the eset.
If several gene sets have the same name, they will be combine to extract the top gene sets.}

\item{geneSetsVar}{variable of the featureData used to match the genes contained in geneSets,
most probably ENTREZID, if not specified the featureNames of the eSet are used}

\item{geneSetsMaxNChar}{maximum number of characters for pathway names, by default keep entire names}

\item{returnTopElements}{logical if TRUE (FALSE by default) return the outlying elements}
}
\value{
Data.frame with coordinates and labels of the top elements
}
\description{
create \code{geom_text} object with top genes/sample/pathways
}
\author{
Laure Cougnaud
}
\keyword{internal}
