# input and output definitions ---------
data("stackepi")

set.seed(2807)

gr <- GenomicRanges::GRanges(
    seqnames = S4Vectors::Rle(c("chr1", "chr2", "chr1", "chr3"), c(10, 10, 15, 15)),
    ranges = IRanges::IRanges(101:150, end = 111:160, names = paste0("r", 1:50)),
    strand = S4Vectors::Rle(BiocGenerics::strand(c("-", "+", "*", "+", "-")), c(10, 15, 5, 10, 10)),
    gene_id = base::sample(SummarizedExperiment::rowRanges(stackepi)$gene_id, size = 50),
    score = base::sample(1:50),
    GC = base::sample(seq(1, 0, length=50)))

this_order_key <- data.frame(gene_id = gr$gene_id, exp = rnorm(length(gr$GC)))

result1 <- new("GRanges",seqnames=new("Rle",values=structure(c(1L,
3L,1L,2L,1L,2L,1L,3L,1L,3L,2L,1L,3L,1L,3L,2L,1L,
2L,3L,2L,3L,1L,3L,1L,2L,3L,1L,3L),.Label=c("chr1",
"chr2","chr3"),class="factor"),lengths=c(3L,1L,4L,1L,
4L,1L,3L,1L,1L,1L,1L,1L,1L,1L,3L,1L,1L,1L,2L,4L,
1L,5L,1L,1L,1L,3L,1L,1L),elementMetadata=NULL,metadata=list()),
ranges=new("IRanges",start=c(126L,133L,123L,149L,
122L,124L,105L,132L,116L,128L,125L,107L,131L,114L,
103L,121L,134L,138L,101L,150L,113L,110L,143L,108L,
137L,142L,141L,112L,109L,117L,140L,144L,120L,115L,
118L,111L,139L,104L,135L,102L,106L,127L,136L,130L,
119L,145L,147L,148L,129L,146L),width=c(11L,11L,
11L,11L,11L,11L,11L,11L,11L,11L,11L,11L,11L,11L,
11L,11L,11L,11L,11L,11L,11L,11L,11L,11L,11L,11L,
11L,11L,11L,11L,11L,11L,11L,11L,11L,11L,11L,11L,
11L,11L,11L,11L,11L,11L,11L,11L,11L,11L,11L,11L
),NAMES=c("ENSSSCG00000048651","ENSSSCG00000044944",
"ENSSSCG00000016760","ENSSSCG00000016678","ENSSSCG00000016609",
"ENSSSCG00000020232","ENSSSCG00000016726","ENSSSCG00000041996",
"ENSSSCG00000016629","ENSSSCG00000048536","ENSSSCG00000049355",
"ENSSSCG00000021250","ENSSSCG00000016751","ENSSSCG00000027063",
"ENSSSCG00000038700","ENSSSCG00000046715","ENSSSCG00000029241",
"ENSSSCG00000044814","ENSSSCG00000027024","ENSSSCG00000016441",
"ENSSSCG00000047982","ENSSSCG00000037869","ENSSSCG00000048496",
"ENSSSCG00000037391","ENSSSCG00000051014","ENSSSCG00000016711",
"ENSSSCG00000019958","ENSSSCG00000040690","ENSSSCG00000023820",
"ENSSSCG00000016569","ENSSSCG00000049721","ENSSSCG00000018762",
"ENSSSCG00000016695","ENSSSCG00000051575","ENSSSCG00000048136",
"ENSSSCG00000044134","ENSSSCG00000025642","ENSSSCG00000048079",
"ENSSSCG00000043992","ENSSSCG00000016553","ENSSSCG00000016428",
"ENSSSCG00000016572","ENSSSCG00000027826","ENSSSCG00000016742",
"ENSSSCG00000016582","ENSSSCG00000033514","ENSSSCG00000016433",
"ENSSSCG00000026894","ENSSSCG00000030388","ENSSSCG00000050311"
),elementType="ANY",elementMetadata=NULL,metadata=list()),
strand=new("Rle",values=structure(c(3L,1L,2L,1L,
2L,1L,3L,1L,2L,1L,2L,1L,2L,1L,2L,1L,2L,1L,2L,
1L,2L,1L,2L,1L,2L,3L,1L,3L,1L,2L,3L,2L),.Label=c("+",
"-","*"),class="factor"),lengths=c(1L,2L,1L,2L,
1L,2L,1L,1L,1L,2L,1L,3L,2L,1L,3L,1L,2L,1L,1L,
2L,1L,5L,1L,1L,2L,1L,1L,1L,1L,3L,1L,1L),elementMetadata=NULL,
metadata=list()),seqinfo=new("Seqinfo",seqnames=c("chr1",
"chr2","chr3"),seqlengths=c(NA_integer_,NA_integer_,
NA_integer_),is_circular=c(NA,NA,NA),genome=c(NA_character_,
NA_character_,NA_character_)),elementMetadata=new("DFrame",
rownames=NULL,nrows=50L,listData=list(gene_id=c("ENSSSCG00000048651",
"ENSSSCG00000044944","ENSSSCG00000016760","ENSSSCG00000016678",
"ENSSSCG00000016609","ENSSSCG00000020232","ENSSSCG00000016726",
"ENSSSCG00000041996","ENSSSCG00000016629","ENSSSCG00000048536",
"ENSSSCG00000049355","ENSSSCG00000021250","ENSSSCG00000016751",
"ENSSSCG00000027063","ENSSSCG00000038700","ENSSSCG00000046715",
"ENSSSCG00000029241","ENSSSCG00000044814","ENSSSCG00000027024",
"ENSSSCG00000016441","ENSSSCG00000047982","ENSSSCG00000037869",
"ENSSSCG00000048496","ENSSSCG00000037391","ENSSSCG00000051014",
"ENSSSCG00000016711","ENSSSCG00000019958","ENSSSCG00000040690",
"ENSSSCG00000023820","ENSSSCG00000016569","ENSSSCG00000049721",
"ENSSSCG00000018762","ENSSSCG00000016695","ENSSSCG00000051575",
"ENSSSCG00000048136","ENSSSCG00000044134","ENSSSCG00000025642",
"ENSSSCG00000048079","ENSSSCG00000043992","ENSSSCG00000016553",
"ENSSSCG00000016428","ENSSSCG00000016572","ENSSSCG00000027826",
"ENSSSCG00000016742","ENSSSCG00000016582","ENSSSCG00000033514",
"ENSSSCG00000016433","ENSSSCG00000026894","ENSSSCG00000030388",
"ENSSSCG00000050311"),exp=c(2.71477629738032,2.21629676929324,
1.85352044157104,1.77632072099662,1.41655812379381,
1.35321992534542,1.17012702891678,1.11943062897585,
0.977483494353636,0.965921522504605,0.944926617451407,
0.810438507519481,0.806256667089439,0.795636349816916,
0.790127297225538,0.732767210739191,0.539880570343067,
0.503233883941951,0.381324263019596,0.376286488325125,
0.335085581293164,0.308923547935741,0.299547343587238,
0.272176843726719,0.121241339524806,0.11370824808282,
0.0783250259475899,0.0367908398123509,0.0254700804162779,
-0.0453402630786151,-0.0557302820015271,-0.120747001507551,
-0.177825741698792,-0.186991574771705,-0.233555545826962,
-0.254418141662234,-0.256555808292254,-0.62969501734125,
-0.670166544273178,-0.723684465547532,-0.785572911211998,
-0.837884251825161,-0.876339722197933,-0.889100378300106,
-0.936347410876076,-1.05741058069846,-1.44504461620228,
-1.46225623386426,-1.64400632448932,-1.75687945598018
),score=c(22L,25L,16L,7L,46L,9L,44L,27L,43L,
26L,3L,5L,29L,13L,20L,23L,4L,45L,6L,19L,39L,
47L,15L,38L,41L,12L,49L,14L,42L,18L,28L,48L,
10L,37L,50L,35L,8L,17L,30L,24L,11L,40L,34L,
21L,1L,32L,31L,2L,33L,36L),GC=c(0.530612244897959,
0.102040816326531,0.408163265306122,0,0.183673469387755,
0.673469387755102,0.877551020408163,0.959183673469388,
0.204081632653061,0.0408163265306123,0.387755102040816,
0.938775510204082,0.0612244897959184,0.469387755102041,
0.244897959183674,0.285714285714286,0.510204081632653,
0.775510204081633,0.63265306122449,0.224489795918367,
0.857142857142857,0.142857142857143,0.979591836734694,
0.306122448979592,0.714285714285714,0.448979591836735,
0.26530612244898,0.795918367346939,0.653061224489796,
0.693877551020408,0.0204081632653061,0.816326530612245,
0.36734693877551,0.591836734693878,0.428571428571429,
0.918367346938776,1,0.612244897959184,0.897959183673469,
0.755102040816326,0.836734693877551,0.551020408163265,
0.163265306122449,0.571428571428571,0.326530612244898,
0.73469387755102,0.0816326530612246,0.346938775510204,
0.122448979591837,0.489795918367347)),elementType="ANY",
elementMetadata=NULL,metadata=list()),elementType="ANY",
metadata=list())

ramdomOrder <- data.frame(
    gene_id = SummarizedExperiment::rowRanges(stackepi)$gene_id,
    value = rnorm(length(stackepi))
)

result2 <- rep(0, 20)

# tests -------------
test_that("test the sort with value", {
    expect_equal(
        tail(addMetricAndArrangeGRanges(
            SummarizedExperiment::rowRanges(stackepi),
            ramdomOrder, gr_key = "gene_id",
            order_key = "gene_id",
            order_value = "exp" )$exp, n = 20),
        result2
    )
})

test_that("test the sort with GC", {
    expect_equal(
        addMetricAndArrangeGRanges(gr, this_order_key, gr_key = "gene_id",
                                   order_key = "gene_id", order_value = "exp" ),
        result1
     )
})
