% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addBins.R
\name{addBins}
\alias{addBins}
\title{addBins()}
\usage{
addBins(rse, nbins = 5L, bin = NULL)
}
\arguments{
\item{rse}{a SummarizedExperiment or a GRanges object.}

\item{nbins}{an integer number, the number of bins.}

\item{bin}{a vector containing pre-determined bins, in the same
order as \code{gr}.}
}
\value{
the RangedSummarizedExperiment or GRanges object with a
new \code{bin} metadata column
}
\description{
Add an optional \code{bin} metadata column to \code{gr},
to serve as annotations
for the epistack plots.
}
\details{
\code{nbins} is taken into account only if \code{bin} is \code{NULL}.
\code{rse} should be sorted first, usually with the
\code{addMetricAndArrangeGRanges()}
function. \code{addBin(rse, bin = vec)} is equivalent to
\code{rse$bin <- vec}, while
\code{addBin(rse, nbins = 5)} will create 5 bins of equal size based on
\code{rse}
order.
}
\examples{
data("stackepi")
addBins(stackepi)

# 3 bins instead of 5
addBins(stackepi, nbins = 3)

# assign bins using a vector
addBins(stackepi, bin = rep(c("a", "b", "c"),
 length.out = length(stackepi)))
}
\seealso{
\code{\link[epistack]{addMetricAndArrangeGRanges}}
\code{\link[epistack]{plotBinning}}
}
