% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentGenome.R
\name{segmentGenome}
\alias{segmentGenome}
\title{Segmentation of a genome in non-overlapping windows}
\usage{
segmentGenome(genome, window, rm.gap = TRUE, rm.blacklist = TRUE)
}
\arguments{
\item{genome}{a string with the name of the genome (e.g. 'hg19')}

\item{window}{an integer with the window size}

\item{rm.gap}{a logical indicating gap regions should be removed}

\item{rm.blacklist}{a logical indicating blacklisted regions should be 
removed}
}
\value{
a GRanges object with the binned genome
}
\description{
This function segments a genome into non-overlapping windows.
}
\examples{

gr <- segmentGenome(genome = 'mm10', window = 500)

}
\references{
\url{https://github.com/plbaldoni/epigraHMM}
}
\author{
Pedro L. Baldoni, \email{pedrobaldoni@gmail.com}
}
