% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epigraHMMDataSetFromMatrix.R
\name{epigraHMMDataSetFromMatrix}
\alias{epigraHMMDataSetFromMatrix}
\title{Create a epigraHMMDataSet from matrices of counts}
\usage{
epigraHMMDataSetFromMatrix(countData, colData, rowRanges = NULL)
}
\arguments{
\item{countData}{a matrix (or a list of matrices). If countData is a list of matrices,
matrices must be named, have the same dimensions, and, at least, a matrix with name 'counts' must exist (see details).}

\item{colData}{a \code{data.frame} with columns \code{condition} and \code{replicate}.
\code{condition} refers to the experimental condition identifier (e.g. cell line name). \code{replicate} refers to the replicate identification number (unique for each condition).}

\item{rowRanges}{an optional GRanges object with the genomic coordinates of the \code{countData}}
}
\value{
An epigraHMMDataSet object with sorted colData regarding conditions and replicates.
Experimental counts will be stored in the 'counts' assay in the resulting epigraHMMDataSet object.
If `countData` is a list of matrices, the resulting 'counts' assay will be equal to `countData[['counts']]`.

Additional matrices can be included in the epigraHMMDataSet. For example, if one wants to include counts from an
input control experiment from `countData[['controls']]`, an assay 'control' will be added to the resulting epigraHMMDataSet..
}
\description{
This function creates a \code{\link[SummarizedExperiment]{RangedSummarizedExperiment}} object from matrices of counts.
It is used to store the input data, the model offsets, and the results from the peak calling algorithms.
}
\details{
Additional columns included in the colData input will be passed to the resulting epigraHMMDataSet assay and can be acessed via \code{colData()} function.
}
\examples{

countData <- list('counts' = matrix(rpois(4e5,10),ncol = 4),
'controls' = matrix(rpois(4e5,5),ncol = 4))
colData <- data.frame(condition = c('A','A','B','B'), replicate = c(1,2,1,2))
object <- epigraHMMDataSetFromMatrix(countData,colData)

}
\references{
\url{https://github.com/plbaldoni/epigraHMM}
}
\author{
Pedro L. Baldoni, \email{pedrobaldoni@gmail.com}
}
