% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epidecodeR.R
\name{plot_test}
\alias{plot_test}
\title{Generates boxplot of distribution of log2FC of dysregulated genes and adjusted P value of signficance test of difference in mean log2FC between groups computed using one-way ANOVA test}
\usage{
plot_test(obj, title, ylab)
}
\arguments{
\item{obj}{epidecodeR object - epidecodeR object generated using epidecodeR function}

\item{title}{Title of the plot}

\item{ylab}{Y-axis label}
}
\value{
Boxplot of distribution of log2FC of dysregulated genes between groups
}
\description{
Generates boxplot of distribution of log2FC of dysregulated genes and adjusted P value of signficance test of difference in mean log2FC between groups computed using one-way ANOVA test
}
\examples{
events<-system.file("extdata","NOMO-1_ref_peaks.bed",package="epidecodeR")
deg<-system.file("extdata", "FTOi.txt", package="epidecodeR")
epiobj<-epidecodeR(events=events,deg=deg,pval=0.05,param=3,ints=c(2,4))
plot_test(epiobj,title="log2FC distribution based on m6A degree",ylab="log2FC")
}
