% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiSeeker-package.R
\docType{data}
\name{tagMatrix}
\alias{tagMatrix}
\title{Example data of tagMatrix}
\format{
A numeric matrix with \code{n} genes × 500 bins.
}
\value{
matrix
}
\description{
tagMatrix result used to demonstrate TSS enrichment visualization and
tag distribution plotting functions in \pkg{epiSeeker}. See data-raw/example_data.R
}
\section{Provenance}{

The tag matrix was generated using a sample peak file obtained from
\code{getSampleFiles()[[4]]}.  
Peaks were imported via \code{readPeakFile()} and processed using
\code{epiSeeker::getTagMatrix()} with the following settings:
\itemize{
  \item Transcript database: \code{TxDb.Hsapiens.UCSC.hg19.knownGene}
  \item Annotation mode: \code{type = "start_site"}, \code{by = "gene"}
  \item TSS window: upstream 3000 bp, downstream 3000 bp
  \item Peak weight: column \code{"V5"} of the peak file
  \item Number of bins: \code{nbin = 500}
}
}

\section{Data structure}{

A numeric matrix in which:
\describe{
  \item{Rows}{Represent individual genes contributing tags around their TSS.}
  \item{Columns}{Represent evenly spaced bins across the TSS window from
        -3000 bp to +3000 bp (500 bins total).}
}
}

