% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDistToTSS.R
\name{plotDistToTSS.data.frame}
\alias{plotDistToTSS.data.frame}
\title{plotDistToTSS.data.frame}
\usage{
plotDistToTSS.data.frame(
  peakDist,
  distanceColumn = "distanceToTSS",
  distanceBreaks = c(0, 1000, 3000, 5000, 10000, 1e+05),
  palette = NULL,
  xlab = "",
  ylab = "Binding sites (\%) (5'->3')",
  title = "Distribution of transcription factor-binding loci relative to TSS",
  categoryColumn = ".id"
)
}
\arguments{
\item{peakDist}{peak annotation}

\item{distanceColumn}{column name of the distance from peak to nearest gene}

\item{distanceBreaks}{default is `c(0, 1000, 3000, 5000, 10000, 100000)`}

\item{palette}{palette name for coloring different distances. Run `RColorBrewer::display.brewer.all()` to see all applicable values.}

\item{xlab}{x label}

\item{ylab}{y label}

\item{title}{figure title}

\item{categoryColumn}{category column, default is ".id"}
}
\value{
bar plot that summarize distance from peak to
TSS of the nearest gene.
}
\description{
Plot feature distribution based on the distances to the TSS
}
\seealso{
\code{\link{annotateSeq}}
}
\author{
Guangchuang Yu \url{https://guangchuangyu.github.io}
}
