% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-verb.R
\name{mutate.GRanges}
\alias{mutate.GRanges}
\title{Extend mutate to Peak (GRanges class object)}
\usage{
\method{mutate}{GRanges}(
  .data,
  ...,
  .by = NULL,
  .keep = c("all", "used", "unused", "none"),
  .before = NULL,
  .after = NULL
)
}
\arguments{
\item{.data}{granges object}

\item{...}{additional parameters}

\item{.by}{Optional grouping variable(s) (column name or variable expression) 
specifying which columns to group by for operations}

\item{.keep}{Character vector specifying which columns to retain. Possible values:
"all" (retain all columns, default), "used" (retain only columns used in calculations),
"unused" (retain only columns not used in calculations), "none" (retain only newly created columns)}

\item{.before}{Column name or position index specifying where to insert new columns before}

\item{.after}{Column name or position index specifying where to insert new columns after}
}
\value{
A processed GRanges object containing the added or modified columns
}
\description{
Extend mutate to Peak (GRanges class object)
}
\examples{
peakfile <- system.file("extdata", "sample_peaks.txt", package="epiSeeker")
peak <- readPeakFile(peakfile)
dplyr::mutate(peak, score = tags)
}
