% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-verb.R
\name{filter.GRanges}
\alias{filter.GRanges}
\title{Extend filter to Peak (GRanges class object)}
\usage{
\method{filter}{GRanges}(.data, ..., .by = NULL, .preserve = FALSE)
}
\arguments{
\item{.data}{granges object}

\item{...}{additional parameters}

\item{.by}{Optional grouping variable(s) (column name or variable expression) 
specifying which columns to group by when applying filters}

\item{.preserve}{Logical value indicating whether to preserve the original grouping 
structure when .by is specified. If TRUE, group order and identities are maintained}
}
\value{
A filtered GRanges object containing only rows that meet the specified criteria

grange object
}
\description{
Extend filter to Peak (GRanges class object)
}
\examples{
peakfile <- system.file("extdata", "sample_peaks.txt", package="epiSeeker")
peak <- readPeakFile(peakfile)
dplyr::filter(peak, fold_enrichment > 20)
}
