% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichOverlap.R
\name{enrichAnnoOverlap}
\alias{enrichAnnoOverlap}
\title{enrichAnnoOverlap}
\usage{
enrichAnnoOverlap(
  queryPeak,
  targetPeak,
  TxDb = NULL,
  pAdjustMethod = "BH",
  chainFile = NULL,
  distanceToTSS_cutoff = NULL
)
}
\arguments{
\item{queryPeak}{query bed file}

\item{targetPeak}{target bed file(s) or folder containing bed files}

\item{TxDb}{TxDb}

\item{pAdjustMethod}{pvalue adjustment method}

\item{chainFile}{chain file for liftOver}

\item{distanceToTSS_cutoff}{restrict nearest gene annotation by distance cutoff}
}
\value{
data.frame
}
\description{
Calculate overlap significance of ChIP experiments based on their nearest gene annotation
}
\examples{
if (interactive()) {
  require(TxDb.Hsapiens.UCSC.hg38.knownGene)
  txdb <- TxDb.Hsapiens.UCSC.hg38.knownGene
  peakfile <- system.file("extdata", "demo_peak.txt", package="epiSeeker")
  enrichAnnoOverlap(peakfile, peakfile, txdb)
}
}
\author{
G Yu
}
