% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_results.R
\name{plot.epiScreen}
\alias{plot.epiScreen}
\title{Plot screen.}
\usage{
\method{plot}{epiScreen}(
  x,
  global = TRUE,
  ind = NULL,
  colorkey = TRUE,
  cexGene = 1,
  off = 0.05,
  cexLegend = 1,
  ...
)
}
\arguments{
\item{x}{object of class epiScreen}

\item{global}{plot global distribution or for each pair (FALSE)}

\item{ind}{index of pairs to plot}

\item{colorkey}{if TRUE prints colorkey}

\item{cexGene}{size of modulator annotation}

\item{off}{relative distance from the gene names to the respective
likelihoods}

\item{cexLegend}{font size of the legend}

\item{...}{other arguments}
}
\value{
plot(s) of an epiNEM screen analysis
}
\description{
Plots the sresults of a systematic knock-out screen
}
\examples{
data <- matrix(sample(c(0,1), 100*9, replace = TRUE), 100, 9)
colnames(data) <- c("A.B", "A.C", "B.C", "A", "B", "C", "D", "E", "G")
rownames(data) <- paste("E", 1:100, sep = "_")
res <- epiScreen(data)
plot(res)
plot(res, global = FALSE, ind = 1:3)
}
