% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiN.R
\name{epiNEM}
\alias{epiNEM}
\title{Epistatic NEMs - main function.}
\usage{
epiNEM(
  filename = "random",
  method = "greedy",
  nIterations = 10,
  nModels = 0,
  random = list(single = 4, double = 1, reporters = 100, FPrate = 0.1, FNrate = 0.1,
    replicates = 1),
  ltype = "marginal",
  para = c(0.13, 0.05),
  init = NULL
)
}
\arguments{
\item{filename}{A binary, tab-delimited matrix.
Columns: single and double knockdowns.
Rows: genes showing effect or not?
Default: random; artificial data is
generated to 'random' specifications}

\item{method}{greedy or exhaustive search.
Default: greedy}

\item{nIterations}{number of iterations.
Default: 10}

\item{nModels}{number of Models. Default: 0}

\item{random}{list specifying how the
data should be generated:
no. of single mutants, no. of
double mutants, no. of reporterGenes,
FP-rate, FN-rate, no. of replicates}

\item{ltype}{likelihood either
"marginal" or "maximum"}

\item{para}{false positive and
false negative rates}

\item{init}{adjacency matrix to initialise the greedy search}
}
\value{
List object with an adjacency matrix denoting the network,
the model of the silencing scheme (rows are knock-downs, columns
are signalling genes), a string with the inferred logial gates,
a column indices denoting position of logical gates, the log transformed
likelihood and the effect reporter distribution (rows are the signalling
genes including the null node).
}
\description{
This function contains the inference
algorithm to learn logical networks from knock-down data including
double knock-downs.
}
\examples{
data <- matrix(sample(c(0,1), 100*4, replace = TRUE), 100, 4)
colnames(data) <- c("A", "A.B", "B", "C")
rownames(data) <- paste("E", 1:100, sep = "_")
res <- epiNEM(data, method = "exhaustive")
plot(res)
}
\seealso{
nem
}
\author{
Madeline Diekmann
}
