% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/dotplot.R
\name{dotplot}
\alias{dotplot}
\alias{dotplot,enrichResult-method}
\alias{dotplot,gseaResult-method}
\alias{dotplot,compareClusterResult-method}
\alias{dotplot,compareClusterResult,ANY-method}
\alias{dotplot,enrichResultList-method}
\alias{dotplot,enrichResultList,ANY-method}
\alias{dotplot,gseaResultList-method}
\alias{dotplot,gseaResultList,ANY-method}
\alias{dotplot.enrichResult}
\alias{dotplot.compareClusterResult}
\title{dotplot}
\usage{
dotplot(object, ...)

\S4method{dotplot}{enrichResult}(
  object,
  x = "GeneRatio",
  color = "p.adjust",
  showCategory = 10,
  size = NULL,
  split = NULL,
  font.size = 12,
  title = "",
  orderBy = "x",
  label_format = 30,
  ...
)

\S4method{dotplot}{gseaResult}(
  object,
  x = "GeneRatio",
  color = "p.adjust",
  showCategory = 10,
  size = NULL,
  split = NULL,
  font.size = 12,
  title = "",
  orderBy = "x",
  label_format = 30,
  ...
)

\S4method{dotplot}{compareClusterResult}(
  object,
  x = "Cluster",
  color = "p.adjust",
  showCategory = 5,
  split = NULL,
  font.size = 12,
  title = "",
  by = "geneRatio",
  size = NULL,
  includeAll = TRUE,
  label_format = 30,
  ...
)

\S4method{dotplot}{enrichResultList}(
  object,
  x = "GeneRatio",
  color = "p.adjust",
  showCategory = 10,
  size = NULL,
  split = NULL,
  font.size = 12,
  title = "",
  orderBy = "x",
  label_format = 30,
  ...
)

\S4method{dotplot}{gseaResultList}(
  object,
  x = "GeneRatio",
  color = "p.adjust",
  showCategory = 10,
  size = NULL,
  split = NULL,
  font.size = 12,
  title = "",
  orderBy = "x",
  label_format = 30,
  ...
)

dotplot.enrichResult(
  object,
  x = "geneRatio",
  color = "p.adjust",
  showCategory = 10,
  size = NULL,
  split = NULL,
  font.size = 12,
  title = "",
  orderBy = "x",
  label_format = 30,
  decreasing = TRUE
)

dotplot.compareClusterResult(
  object,
  x = "Cluster",
  colorBy = "p.adjust",
  showCategory = 5,
  by = "geneRatio",
  size = "geneRatio",
  split = NULL,
  includeAll = TRUE,
  font.size = 12,
  title = "",
  label_format = 30,
  group = FALSE,
  shape = FALSE,
  facet = NULL,
  strip_width = 15
)
}
\arguments{
\item{object}{compareClusterResult object}

\item{...}{additional parameters.}

\item{x}{variable for x-axis, one of 'GeneRatio' and 'Count'}

\item{color}{variable used to color enriched terms,
e.g. 'pvalue', 'p.adjust' or 'qvalue'}

\item{showCategory}{number of categories to display or a vector of terms.}

\item{size}{variable used to scale the sizes of categories,
one of "geneRatio", "Percentage" and "count"}

\item{split}{apply `showCategory` to each category specified by the 'split', e.g., "ONTOLOGY", "category" and "intersect".  Default is NULL and do nothing}

\item{font.size}{font size}

\item{title}{figure title}

\item{orderBy}{The order of the Y-axis}

\item{label_format}{a numeric value sets wrap length, alternatively a
custom function to format axis labels.
by default wraps names longer than 30 characters}

\item{by}{one of "geneRatio", "Percentage" and "count"}

\item{includeAll}{logical value}

\item{decreasing}{logical. Should the orderBy order be increasing or decreasing?}

\item{colorBy}{variable used to color enriched terms,
e.g. 'pvalue', 'p.adjust' or 'qvalue'}

\item{group}{a logical value, whether to connect the
nodes of the same group with wires.}

\item{shape}{a logical value, whether to use nodes of
different shapes to distinguish the group it belongs to}

\item{facet}{apply `facet_grid` to the plot by specified variable, e.g., "ONTOLOGY", "category" and "intersect".}

\item{strip_width}{width of strip text (facet label).}
}
\value{
plot.
}
\description{
Dot plot for enrichment result
}
\examples{
\dontrun{
    library(DOSE)
    data(geneList)
    de <- names(geneList)[1:100]
    x <- enrichDO(de)
    dotplot(x)
    # use `showCategory` to select the displayed terms. It can be a number of a vector of terms.
    dotplot(x, showCategory = 10)
    categories <- c("pre-malignant neoplasm", "intestinal disease",
                   "breast ductal carcinoma", "non-small cell lung carcinoma")
    dotplot(x, showCategory = categories)
    # It can also graph compareClusterResult
    data(gcSample)
    library(clusterProfiler)
    library(DOSE)
    library(org.Hs.eg.db)
    data(gcSample)
    xx <- compareCluster(gcSample, fun="enrichGO", OrgDb="org.Hs.eg.db")
    xx2 <- pairwise_termsim(xx)
    library(ggstar)
    dotplot(xx2)
    dotplot(xx2, shape = TRUE)
    dotplot(xx2, group = TRUE)
    dotplot(xx2, x = "GeneRatio", group = TRUE, size = "count")
}
}
\author{
Guangchuang Yu
}
