% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodsInternal.R
\encoding{UTF-8}
\name{formatInformationForCXJSON}
\alias{formatInformationForCXJSON}
\title{Transform the node and edge information into a format easy to process 
to create a CX JSON text file}
\usage{
formatInformationForCXJSON(results)
}
\arguments{
\item{results}{a \code{list} containing the information about the 
nodes and edges present in the network. TODOS}
}
\value{
a \code{list} containing 4 entries:
\itemize{
\item{\code{"nodes"}: a \code{data.frame} containing the information about
the nodes present in the network.}
\item{\code{"edges"}: a \code{data.frame} containing the information about
the edges present in the network.}
\item{\code{"nodeAttributes"}: a \code{data.frame} containing the attributes
associated to the nodes present in the network.}
\item{\code{"edgesAttributes"}: a \code{data.frame} containing the 
attributes associated to the edges present in the network}
}
}
\description{
Extract information about nodes and edges that is necessary
to create the CX JSON text representing the network
}
\examples{

## Loading dataset containing result from an enrichment analysis done with
## gprofiler2
data(parentalNapaVsDMSOEnrichment)

## Only retained the GO Molecular Function results
results <- parentalNapaVsDMSOEnrichment$result[
        parentalNapaVsDMSOEnrichment$result$source == "GO:MF", ]

## Extract node and edge information
info <- enrichViewNet:::extractNodesAndEdgesInformation(gostResults=results, 
            gostObject=parentalNapaVsDMSOEnrichment)
            
## Format node and edge information
information <- enrichViewNet:::formatInformationForCXJSON(result=info)

}
\author{
Astrid Deschênes
}
\keyword{internal}
