% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodsInternal.R
\encoding{UTF-8}
\name{extractInformationWhenIntersection}
\alias{extractInformationWhenIntersection}
\title{Extract node and edge information to be used to create network 
when interaction column is present}
\usage{
extractInformationWhenIntersection(gostResults)
}
\arguments{
\item{gostResults}{a \code{data.frame} containing the terms retained
for the creation of the network. The \code{data.frame} must contain a
column called "intersection".}
}
\value{
\code{list} containing 2 entries:
\itemize{
\item{\code{"geneNodes"}: a \code{data.frame} containing the information 
about the nodes present in the network. The nodes are genes.}
\item{\code{"termNodes"}: a \code{data.frame} containing the information 
about the nodes present in the network. The nodes are terms.}
\item{\code{"edges"}: a \code{data.frame} containing the information about
the edges present in the network. The edges connect one gene to one term.}
}
}
\description{
Create a list containing all node and edge information needed
to create the network
}
\examples{

## Loading dataset containing result from an enrichment analysis done with
## gprofiler2
data(parentalNapaVsDMSOEnrichment)

## Only retained the GO Molecular Function results
results <- parentalNapaVsDMSOEnrichment$result[
        parentalNapaVsDMSOEnrichment$result$source == "GO:MF", ]

## Extract node and edge information
information <-
    enrichViewNet:::extractInformationWhenIntersection(
        gostResults=results)

}
\author{
Astrid Deschênes
}
\keyword{internal}
