% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodsEmapInternal.R
\encoding{UTF-8}
\name{createBasicEmap}
\alias{createBasicEmap}
\title{Create a basic enrichment map}
\usage{
createBasicEmap(
  gostResults,
  backgroundGenes,
  showCategory,
  categoryLabel,
  categoryNode,
  significantMethod,
  line,
  ...
)
}
\arguments{
\item{gostResults}{a \code{data.frame} containing the enrichment 
results to be plot.}

\item{backgroundGenes}{a \code{vector} of \code{character} string 
representing the name of the genes present in the request.}

\item{showCategory}{a positive \code{integer} or a \code{vector} of 
\code{characters} representing terms.  If a \code{integer}, the first 
\code{n} terms will be displayed. If \code{vector} of terms, 
the selected terms will be displayed.}

\item{categoryLabel}{a positive \code{numeric} representing the amount by 
which plotting category nodes label size should be scaled relative 
to the default (1).}

\item{categoryNode}{a positive \code{numeric} representing the amount by 
which plotting category nodes should be scaled relative to the default (1).}

\item{significantMethod}{a \code{character} string representing the name 
of the multiple testing correction method used on the results.}

\item{line}{a non-negative \code{numeric} representing the scale of line 
width.}

\item{...}{additional arguments that will be pass to the 
\code{\link[enrichplot]{emapplot}} function.}
}
\value{
a \code{ggplot} object representing the enrichment map.
}
\description{
The function creates a basic enrichment map using functional 
enrichment results.
}
\examples{

## Load the result of an enrichment analysis done with gprofiler2
data(parentalNapaVsDMSOEnrichment)

## Only retain the results section
gostResults <- as.data.frame(parentalNapaVsDMSOEnrichment$result)

## Limit the results to Wikipathways
## and remove the root term
gostResults <- gostResults[which(gostResults$source == "WP"),]
gostResults <- gostResults[which(gostResults$term_name != "WIKIPATHWAYS"),]

## Extract meta data information
meta <- parentalNapaVsDMSOEnrichment$meta

## Get all background genes
backgroundGenes <- meta$query_metadata$queries[["parental_napa_vs_DMSO"]]

## Get significant method
significantMethod <- meta$query_metadata$significance_threshold_method

## Create basic enrichment map using Wikipathways terms
enrichViewNet:::createBasicEmap(gostResults=gostResults, 
    backgroundGenes=backgroundGenes, showCategory=30L, 
    categoryLabel=1, categoryNode=1,
    significantMethod=significantMethod, line=1)
    
}
\author{
Astrid Deschênes
}
\keyword{internal}
