% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conservedMotifs.R
\name{conservedMotifs}
\alias{conservedMotifs}
\title{check the conserved motifs in the orthologs}
\usage{
conservedMotifs(
  aln,
  aln_list,
  PWMs,
  queryGenome,
  background = "genome",
  ...,
  output_folder,
  format = c("txt", "html")
)
}
\arguments{
\item{aln}{alignment of multiple DNAs. Output of \link{alignment} function.}

\item{aln_list}{The list of output of \link{searchTFBPS}
such as for human and mouse.}

\item{PWMs}{The Position Weight Matrix list represented as a numeric matrix.
Object of \link[TFBSTools:XMatrixList]{PWMatrixList} or
\link[TFBSTools:XMatrixList]{PFMatrixList}.}

\item{queryGenome}{An object of \link[BSgenome:BSgenome-class]{BSgenome} for
query enhancer.}

\item{background}{Background nucleotide frequencies. Default is "genome".
Refer \link[motifmatchr]{matchMotifs} for details.}

\item{\dots}{Other parameters can be passed to to
\link[motifmatchr:matchMotifs]{matchMotifs}.}

\item{output_folder}{Output folder name.}

\item{format}{The format of output files with motif match positions.
Available formats are 'txt' and 'html'. Default is 'txt'.}
}
\value{
A list of \link[Biostrings:XStringViews-class]{XStringViews}
}
\description{
Print the conserved motifs in the alignments
}
\examples{
library(BSgenome.Hsapiens.UCSC.hg38)
library(BSgenome.Mmusculus.UCSC.mm10)
library(BSgenome.Drerio.UCSC.danRer10)
LEN <- GRanges("chr4", IRanges(19050041, 19051709))
seqEN <- getSeq(BSgenome.Drerio.UCSC.danRer10, LEN)
aln_hs <- readRDS(system.file("extdata", "aln_hs.rds",
               package="enhancerHomologSearch"))
genome(aln_hs) <- Hsapiens
aln_mm <- readRDS(system.file("extdata", "aln_mm.rds",
               package="enhancerHomologSearch"))
genome(aln_mm) <- Mmusculus
al <- alignment(seqEN, list(human=aln_hs, mouse=aln_mm),
                method="ClustalW", order="input")
data(motifs)
conservedMotifs(al[[1]], list(human=aln_hs, mouse=aln_mm),
                motifs[["dist60"]], Drerio)
}
