% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShortRead-methods.R
\docType{methods}
\name{ShortRead additional methods}
\alias{ShortRead additional methods}
\alias{barcodePlot}
\alias{barcodePlot,AlignedRead-method}
\alias{barcodePlot,DNAStringSet-method}
\alias{barcodePlot,ShortReadQ-method}
\alias{chastityFilter}
\alias{chastityFilter,SRFilter-method}
\alias{naPositionFilter}
\alias{naPositionFilter,SRFilter-method}
\alias{demultiplex}
\alias{demultiplex,AlignedRead-method}
\alias{demultiplex,DNAStringSet-method}
\alias{demultiplex,ShortReadQ-method}
\alias{alignData}
\title{Methods extending the ShortRead package functionalities}
\usage{
demultiplex(obj,barcodes=c(),barcodes.qty=12,barcode.length=6,
edition.dist=2,type=c("independant","within"),index.only=FALSE,mc.cores=1L)
barcodePlot(obj,barcodes=c(),type=c("independant","within"),
barcode.length=6,show.barcode=20,...)
chastityFilter(.name="Illumina Chastity Filter")
naPositionFilter(.name="NA Position Filter")
}
\arguments{
\item{obj}{An object derived from class \code{\linkS4class{AlignedRead}}}

\item{barcodes}{A character vector describing the multiplex (i.e. barcode)
sequences used in the experiment.}

\item{barcodes.qty}{An integer describing the number of barcodes}

\item{barcode.length}{An integer describing the barcode length in bp}

\item{edition.dist}{The maximal edition distance (i.e. the number of
changes to apply), to accept an incorrectly sequenced barcode.}

\item{type}{The type of barcode used. \code{independent} represents
barcodes generated by the illumina protocol; i.e. a separate additional
sequencing step performed once the first mate has been sequenced.
\code{within} represents barcodes that are part of the sequenced reads as
established by Lefrancois P et al., BMC Genomics, 2009}

\item{index.only}{simply return the index and not the barcode themselves.}

\item{mc.cores}{A parameter ultimately passed to srdistance to enable
parallel processing on mc.cores. On linux and Mac only, windows task remain
serially processed.}

\item{.name}{An internal string describing the filter}

\item{show.barcode}{An integer specifying how many barcodes should be
displayed in the final output.}

\item{...}{additional graphic parameters}
}
\value{
\itemize{ \item\code{barcodePlot} returns invisibly the barcode
frequencies.  \item\code{chastityFilter} returns a
\code{\linkS4class{SRFilter}} instance.  \item\code{demultiplex} returns a
list of \code{\linkS4class{AlignedRead}} objects.
\item\code{naPositionFilter} returns a \code{\linkS4class{SRFilter}}
instance.  }
}
\description{
These are functions extending the ShortRead packages capabilities:
}
\details{
\itemize{
\item\code{barcodePlot} Creates a plot showing the barcode
distribution of a multiplexed sequencing library.
\item\code{chastityFilter} Creates a \code{\linkS4class{SRFilter}} instance
that filters SolexaExport read according to the chastity filtering value.
\item\code{demultiplex} Split a single \code{\linkS4class{AlignedRead}}
object into a list of \code{\linkS4class{AlignedRead}} objects according to
the barcodes provided by the user. It supports multicore processing
but has a default serial behaviour.
\item\code{naPositionFilter} Creates a
\code{\linkS4class{SRFilter}} instance that filters SolexaExport read
having an NA position.  }

When demultiplexing, the function if provided with just the
\code{\linkS4class{AlignedRead}} will try to find out how many barcodes
were used and what they are. This is unwise to do as many barcodes will get
wrongly sequenced and not always the most frequent ones are the one you
used! It's therefore strongly advised to specify the barcodes' sequences
that were used.
}
\examples{

	\dontrun{
	# the barcode
	barcodes=c("ACACTG","ACTAGC","ATGGCT","TTGCGA")

invisible(download.file(paste0("https://github.com/UPSCb/UPSCb/raw/",
       "master/tutorial/easyRNASeq/multiplex_export.txt.gz"),
       "multiplex_export.txt.gz"))

	# the multiplexed data
	alns <- readAligned(".",
                    pattern="multiplex_export",
                    filter=compose(
                      chastityFilter(),
                      nFilter(2),
                      chromosomeFilter(regex="chr")),
                    type="SolexaExport",
                    withAll=TRUE)

	# barcode plot
	barcodePlot(alns,
            barcodes=barcodes,
            type="within",
            barcode.length=6,
            show.barcode=20,
            main="All samples",
            xlim=c(0,0.5))

	# demultiplexing
	dem.alns <- demultiplex(alns,
                        barcodes=barcodes,
                        edition.dist=2,
                        barcodes.qty=4,
                        type="within")

	# plotting again
	par(mfrow=c(2,2))
	barcode.frequencies <- lapply(
                              names(dem.alns$barcodes),
                              function(barcode,alns){
                                barcodePlot(
                                            alns$barcodes[[barcode]],
                                            barcodes=barcode,
                                            type="within",barcode.length=6,
                                            show.barcode=20,
                                            main=paste(
                                              "Expected barcode:",
                                              barcode))
                              },dem.alns)
	}

}
\seealso{
\code{\linkS4class{SRFilter}} \code{\linkS4class{AlignedRead}}
}
\author{
Nicolas Delhomme
}
\keyword{methods}
