% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_Roh_IS.R
\name{compute_Roh_IS}
\alias{compute_Roh_IS}
\title{Compute Roh immune score (Roh_IS)}
\usage{
compute_Roh_IS(matches, RNA_tpm)
}
\arguments{
\item{matches}{numeric vector indicating the index of signature
genes in \code{RNA_tpm}.}

\item{RNA_tpm}{data.frame containing TPM values with HGNC symbols
in rows and samples in columns.}
}
\value{
A numeric matrix with samples in rows and Roh_IS score
in a column.
}
\description{
Calculates Roh_IS score as the geometric-mean
of its signature genes, defined in Roh et al.,
Sci. Transl. Med., 2017.
}
\references{
Roh, W., Chen, P.-L., Reuben, A., Spencer, C.N.,
Prieto, P.A., Miller, J.P., Gopalakrishnan, V., Wang, F.,
Cooper, Z.A., Reddy, S.M., et al. (2017). Integrated molecular
analysis of tumor biopsies on sequential CTLA-4 and PD-1 blockade
reveals markers of response and resistance. Sci. Transl. Med. 9.
https://doi.org/10.1126/scitranslmed.aah3560.
}
