% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareSignature.R
\name{prepareSignature}
\alias{prepareSignature}
\title{Prepare an L1000 Signature from a given differential gene expression output
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}}
\usage{
prepareSignature(
  dge,
  geneColumn = "Symbol",
  logfcColumn = "logFC",
  pvalColumn = "PValue"
)
}
\arguments{
\item{dge}{A dataframe-like object that has the differential
gene expression information}

\item{geneColumn}{The name of the column that has gene symbols}

\item{logfcColumn}{The name of the column that has log_2 fold-change values}

\item{pvalColumn}{The name of the column that has p-values}
}
\value{
A tibble with the L1000 signature.
}
\description{
This function takes a differential gene expression output from any pipeline
like edgeR or DeSeq2 or any that give you the gene symbol,
log_2 fold-change and p-value
and transforms that into an L1000 signature for later processing.
}
\examples{
# Load example differential expression data from package
dge_file <- system.file("extdata", "dCovid_diffexp.tsv",
    package = "drugfindR"
)
dge_data <- read.delim(dge_file)

# Prepare signature with p-values (standard workflow)
signature <- prepareSignature(
    dge_data,
    geneColumn = "hgnc_symbol",
    logfcColumn = "logFC",
    pvalColumn = "PValue"
)
head(signature)

# Prepare signature without p-values
signature_no_pval <- prepareSignature(
    dge_data,
    geneColumn = "hgnc_symbol",
    logfcColumn = "logFC",
    pvalColumn = NA
)
head(signature_no_pval)

# Custom column names example
custom_dge <- data.frame(
    Gene = c("TP53", "MYC", "BRCA1", "EGFR"),
    FC = c(2.5, -1.8, 3.2, -2.1),
    Pval = c(0.001, 0.01, 0.0001, 0.005)
)

custom_signature <- prepareSignature(
    custom_dge,
    geneColumn = "Gene",
    logfcColumn = "FC",
    pvalColumn = "Pval"
)
print(custom_signature)
}
